% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{graph2Matrix}
\alias{graph2Matrix}
\title{Convert from node and edge graph representation to a sparse adjacency matrix representation}
\usage{
graph2Matrix(edges, nodes, symmetric = TRUE)
}
\arguments{
\item{edges}{A data frame with at least the columns "from" and "to"
referring to edges between ids in the \code{nodes} data frame. If the data
frame includes a numeric "size" variable then graph is assumed to be weighted
and the corresponding matrix entries are set to the size values.}

\item{nodes}{Optional data frame with at least a column named "id"
corresponding to the \code{from} and \code{to} node ids in the \code{edges}
argument. The size of the matrix is determined by  number of rows in the data
frame. If \code{nodes} is missing it will be inferred from the \code{edges}. If
\code{nodes} has a "label" column, the matrix row and column names will be set
to the corresponding node labels.}

\item{symmetric}{Set to \code{FALSE} for directed graphs, or leave as \code{TRUE} for undirected graphs.}
}
\value{
A sparse matrix
}
\description{
Convert from node and edge graph representation to a sparse adjacency matrix representation
}
\examples{
data(LeMis)
M <- graph2Matrix(LeMis$edges, LeMis$nodes)
G <- matrix2graph(M)
}
\seealso{
\code{\link{graphjs}}, \code{\link{graph2Matrix}}
}

