% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_cor.R
\name{pearson_correlation}
\alias{pearson_correlation}
\title{Correlation and covariance calculation for sparse matrix}
\usage{
pearson_correlation(x, y = NULL)
}
\arguments{
\item{x}{Sparse matrix or character vector.}

\item{y}{Sparse matrix or character vector.}
}
\value{
A list with covariance and correlation matrices.
}
\description{
Correlation and covariance calculation for sparse matrix
}
\examples{
m1 <- simulate_sparse_matrix(
  100, 100
)
m2 <- simulate_sparse_matrix(
  100, 100,
  sparsity = 0.05
)
a <- pearson_correlation(m1, m2)
a$cov[1:5, 1:5]
a$cor[1:5, 1:5]
}
