% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pkg_file.R
\name{add_pkg_file}
\alias{add_pkg_file}
\title{Add package file}
\usage{
add_pkg_file(
  desc_file,
  pkg_name = NULL,
  pkg_description = NULL,
  author_name = NULL,
  author_email = NULL,
  github_url = NULL,
  output_dir = NULL,
  use_figlet = TRUE,
  figlet_font = "Slant",
  colors = c("red", "yellow", "green", "magenta", "cyan", "yellow", "green", "white",
    "magenta", "cyan"),
  unicode = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{desc_file}{The DESCRIPTION file.
Must be provided, it will be used to extract package information.
Using \code{add_pkg_file("DESCRIPTION")}, will be created <pkg_name>-package.R based on the DESCRIPTION file.
If you want to use some specific information, such as \code{author_name} or \code{author_email}, you can provide them manually.}

\item{pkg_name}{Character string, the name of the package.
Default is NULL, which will be read from DESCRIPTION file.}

\item{pkg_description}{Character string, short description of the package.
Default is NULL, which will be read from DESCRIPTION file.}

\item{author_name}{Character string, name of the package author.
Default is NULL, which will be read from DESCRIPTION file.}

\item{author_email}{Character string, email of the package author.
Default is NULL, which will be read from DESCRIPTION file.}

\item{github_url}{Character string, GitHub URL of the package.
Default is NULL, which will be read from DESCRIPTION file or constructed based on package name.}

\item{output_dir}{Character string, directory where to save the package file.
Default is NULL, you should specify it, such as 'R/'.}

\item{use_figlet}{Logical, whether to use figlet for ASCII art generation.
Default is TRUE.}

\item{figlet_font}{Character string, figlet font to use.
Default is "Slant".}

\item{colors}{Character vector, colors to use for the logo elements.}

\item{unicode}{Logical, whether to use Unicode symbols.
Default is TRUE.}

\item{verbose}{Logical, whether to print progress messages.
Default is TRUE.}
}
\value{
Creates a file in specified output directory
}
\description{
Automatically generate a file containing functions and related code for R package development.
}
