% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise_feature_vector.R
\name{normalise_feature_vector}
\alias{normalise_feature_vector}
\title{Scale each value into a user-specified range for visualisation and analysis}
\usage{
normalise_feature_vector(
  x,
  method = c("z-score", "Sigmoid", "RobustSigmoid", "MinMax")
)
}
\arguments{
\item{x}{a vector of scalar values}

\item{method}{a rescaling/normalising method to apply. Defaults to \code{"RobustSigmoid"}}
}
\value{
a vector of scalar values normalised into the selected range
}
\description{
Scale each value into a user-specified range for visualisation and analysis
}
\examples{
featMat <- calculate_features(data = simData, 
  id_var = "id", 
  time_var = "timepoint", 
  values_var = "values", 
  group_var = "process", 
  feature_set = "catch22",
  seed = 123)
  
x <- featMat[featMat$names == "DN_HistogramMode_5", ]
xnormed <- normalise_feature_vector(x$values, method = "RobustSigmoid")

}
\author{
Trent Henderson
}
