% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_group_plan.R
\name{row_grp_plan}
\alias{row_grp_plan}
\title{Row Group Plan}
\usage{
row_grp_plan(..., label_loc = element_row_grp_loc(location = "indented"))
}
\arguments{
\item{...}{Row group structure objects separated by commas}

\item{label_loc}{\code{\link[=element_row_grp_loc]{element_row_grp_loc()}} object specifying location}
}
\value{
row_grp_plan object
}
\description{
Define the look of the table groups on the output. This function allows you to
add spaces after blocks and allows you to control how the groups are viewed
whether they span the entire table or are nested as a column.
}
\examples{


  ## single grouping variable example
  sample_grp_plan <- row_grp_plan(
    row_grp_structure(group_val = c("A","C"), element_block(post_space = "---")),
    row_grp_structure(group_val = c("B"), element_block(post_space = " ")),
    label_loc = element_row_grp_loc(location = "column")
  )

  ## example with multiple grouping variables
  sample_grp_plan <- row_grp_plan(
     row_grp_structure(group_val = list(grp1 = "A", grp2 = "b"), element_block(post_space = " ")),
     label_loc = element_row_grp_loc(location = "spanning")
     )

}
\seealso{
\code{\link[=row_grp_structure]{row_grp_structure()}} for more details on how to specify row group
structures, \code{\link[=element_block]{element_block()}} for more details on how to specify spacing
between each group, \code{\link[=element_row_grp_loc]{element_row_grp_loc()}} for more details on how to
specify whether row group titles span the entire table or collapse.

\href{https://gsk-biostatistics.github.io/tfrmt/articles/row_grp_plan.html}{Link to related article}
}
