% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_dynamic_linear_regression}
\alias{sts_dynamic_linear_regression}
\title{Formal representation of a dynamic linear regression model.}
\usage{
sts_dynamic_linear_regression(observed_time_series = NULL, design_matrix,
  drift_scale_prior = NULL, initial_weights_prior = NULL,
  name = NULL)
}
\arguments{
\item{observed_time_series}{optional \code{float} \code{tensor} of shape
\code{batch_shape + [T, 1]} (omitting the trailing unit dimension is also
supported when \code{T > 1}), specifying an observed time series.
Any priors not explicitly set will be given default values according to
the scale of the observed time series (or batch of time series). May
optionally be an instance of \code{sts_masked_time_series}, which includes
a mask \code{tensor} to specify timesteps with missing observations.
Default value: \code{NULL}.}

\item{design_matrix}{float \code{tensor} of shape \code{tf$concat(list(batch_shape, list(num_timesteps, num_features)))}.
This may also optionally be an instance of \code{tf$linalg$LinearOperator}.}

\item{drift_scale_prior}{instance of \code{Distribution} specifying a prior on
the \code{drift_scale} parameter. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}. Default value: \code{NULL}.}

\item{initial_weights_prior}{instance of \code{tfd_multivariate_normal} representing
the prior distribution on the latent states (the regression weights).
Must have event shape \code{list(num_features)}. If \code{NULL}, a weakly-informative
Normal(0, 10) prior is used. Default value: \code{NULL}.}

\item{name}{the name of this component. Default value: 'DynamicLinearRegression'.}
}
\value{
an instance of \code{StructuralTimeSeries}.
}
\description{
The dynamic linear regression model is a special case of a linear Gaussian SSM
and a generalization of typical (static) linear regression. The model
represents regression \code{weights} with a latent state which evolves via a
Gaussian random walk:
}
\details{
\code{ weights[t] ~ Normal(weights[t-1], drift_scale)}

The latent state has dimension \code{num_features}, while the parameters
\code{drift_scale} and \code{observation_noise_scale} are each (a batch of) scalars. The
batch shape of this distribution is the broadcast batch shape of these
parameters, the \code{initial_state_prior}, and the \code{design_matrix}.
\code{num_features} is determined from the last dimension of \code{design_matrix} (equivalent to the
number of columns in the design matrix in linear regression).
}
\seealso{
For usage examples see \code{\link[=sts_fit_with_hmc]{sts_fit_with_hmc()}}, \code{\link[=sts_forecast]{sts_forecast()}}, \code{\link[=sts_decompose_by_component]{sts_decompose_by_component()}}.

Other sts: \code{\link{sts_additive_state_space_model}},
  \code{\link{sts_autoregressive_state_space_model}},
  \code{\link{sts_autoregressive}},
  \code{\link{sts_constrained_seasonal_state_space_model}},
  \code{\link{sts_dynamic_linear_regression_state_space_model}},
  \code{\link{sts_linear_regression}},
  \code{\link{sts_local_level_state_space_model}},
  \code{\link{sts_local_level}},
  \code{\link{sts_local_linear_trend_state_space_model}},
  \code{\link{sts_local_linear_trend}},
  \code{\link{sts_seasonal_state_space_model}},
  \code{\link{sts_seasonal}},
  \code{\link{sts_semi_local_linear_trend_state_space_model}},
  \code{\link{sts_semi_local_linear_trend}},
  \code{\link{sts_sparse_linear_regression}},
  \code{\link{sts_sum}}
}
\concept{sts}
