% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_columns.R
\name{column_crossed}
\alias{column_crossed}
\title{Construct a Crossed Column}
\usage{
column_crossed(keys, hash_bucket_size, hash_key = NULL)
}
\arguments{
\item{keys}{An iterable identifying the features to be crossed. Each element
can be either:
\itemize{
\item string: Will use the corresponding feature which must be of string type.
\item categorical column: Will use the transformed tensor
produced by this column. Does not support hashed categorical columns.
}}

\item{hash_bucket_size}{The number of buckets (> 1).}

\item{hash_key}{Optional: specify the hash_key that will be used by the
\code{FingerprintCat64} function to combine the crosses fingerprints on
\code{SparseCrossOp}.}
}
\value{
A crossed column.
}
\description{
Returns a column for performing crosses of categorical features. Crossed
features will be hashed according to \code{hash_bucket_size}.
}
\section{Raises}{

\itemize{
\item ValueError: If \code{len(keys) < 2}.
\item ValueError: If any of the keys is neither a string nor categorical column.
\item ValueError: If any of the keys is \code{_HashedCategoricalColumn}.
\item ValueError: If \code{hash_bucket_size < 1}.
}
}

\seealso{
Other feature column constructors: \code{\link{column_bucketized}},
  \code{\link{column_categorical_weighted}},
  \code{\link{column_categorical_with_hash_bucket}},
  \code{\link{column_categorical_with_identity}},
  \code{\link{column_categorical_with_vocabulary_file}},
  \code{\link{column_categorical_with_vocabulary_list}},
  \code{\link{column_embedding}},
  \code{\link{column_numeric}}, \code{\link{input_layer}}
}
