% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{tfsummaries}
\alias{tfsummaries}
\alias{mean.tf}
\alias{median.tf}
\alias{sd}
\alias{sd.default}
\alias{sd.tf}
\alias{var}
\alias{var.default}
\alias{var.tf}
\alias{summary.tf}
\title{Functions that summarize \code{tf} objects across argument values}
\usage{
\method{mean}{tf}(x, ...)

\method{median}{tf}(x, na.rm = FALSE, depth = c("MBD", "pointwise"), ...)

sd(x, na.rm = FALSE)

\method{sd}{default}(x, na.rm = FALSE)

\method{sd}{tf}(x, na.rm = FALSE)

var(x, y = NULL, na.rm = FALSE, use)

\method{var}{default}(x, y = NULL, na.rm = FALSE, use)

\method{var}{tf}(x, y = NULL, na.rm = FALSE, use)

\method{summary}{tf}(object, ...)
}
\arguments{
\item{x}{a \code{tf} object}

\item{...}{optional additional arguments.}

\item{na.rm}{logical.  Should missing values be removed?}

\item{depth}{method used to determine the most central element in \code{x}, i.e.,
the median. One of the functional data depths available via \code{\link[=tf_depth]{tf_depth()}} or
\code{"pointwise"} for a pointwise median function.}

\item{y}{\code{NULL} (default) or a vector, matrix or data frame with
    compatible dimensions to \code{x}.   The default is equivalent to
    \code{y = x} (but more efficient).}

\item{use}{an optional character string giving a
    method for computing covariances in the presence
    of missing values.  This must be (an abbreviation of) one of the strings
    \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
    \code{"na.or.complete"}, or \code{"pairwise.complete.obs"}.}

\item{object}{a \code{tfd} object}
}
\value{
a \code{tf} object with the computed result.\cr
\strong{\code{summary.tf}} returns a \code{tf}-vector with the mean function, the
variance function, the functional median, and the functional range
(i.e., \emph{pointwise} min/max) of the central half of the functions,
as defined by \code{\link[=tf_depth]{tf_depth()}}.
}
\description{
These will return a \code{tf} object containing the respective \emph{functional}
statistic. See \code{\link[=tf_fwise]{tf_fwise()}} for scalar summaries
(e.g. \code{tf_fmean} for means, \code{tf_fmax} for max. values) of each entry
in a \code{tf}-vector.
}
\seealso{
\code{\link[=tf_fwise]{tf_fwise()}}

Other tidyfun summary functions: 
\code{\link{functionwise}}
}
\concept{tidyfun summary functions}
