% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.R
\name{tf_approx_linear}
\alias{tf_approx_linear}
\alias{tf_approx_spline}
\alias{tf_approx_none}
\alias{tf_approx_fill_extend}
\alias{tf_approx_locf}
\alias{tf_approx_nocb}
\title{Inter- and extrapolation functions for \code{tfd}-objects}
\usage{
tf_approx_linear(x, arg, evaluations)

tf_approx_spline(x, arg, evaluations)

tf_approx_none(x, arg, evaluations)

tf_approx_fill_extend(x, arg, evaluations)

tf_approx_locf(x, arg, evaluations)

tf_approx_nocb(x, arg, evaluations)
}
\arguments{
\item{x}{new \code{arg} values to approximate/interpolate/extrapolate the function for}

\item{arg}{the \code{arg} values of the \code{evaluations}}

\item{evaluations}{the function values at \code{arg}}
}
\value{
a vector of values of the function defined by the given
\eqn{(x_i, f(x_i))}=\verb{(arg, evaluations)}-tuples at new argument values \code{x}.
}
\description{
These are the currently available \code{evaluator}-functions for \code{tfd}-objects,
which control how the entries are inter-/extrapolated to previously unseen
\code{arg}-values. They all are merely wrappers around \code{\link[zoo:na.fill]{zoo::na.fill()}},
\code{\link[zoo:na.approx]{zoo::na.approx()}}, etc... Note that these are not meant to be called directly --
they are internal functions used by \code{\link[=tf_evaluate.tfd]{tf_evaluate.tfd()}} to do its thing.

The list:
\itemize{
\item \code{tf_approx_linear} for linear interpolation without extrapolation (i.e.,
\code{\link[zoo:na.approx]{zoo::na.approx()}} with \code{na.rm = FALSE})  -- this is the default,
\item \code{tf_approx_spline} for cubic spline interpolation, (i.e., \code{\link[zoo:na.approx]{zoo::na.spline()}}
with \code{na.rm = FALSE}),
\item \code{tf_approx_none} in order to not inter-/extrapolate ever (i.e., \code{\link[zoo:na.fill]{zoo::na.fill()}} with \code{fill = NA})
\item \code{tf_approx_fill_extend} for linear interpolation and constant extrapolation
(i.e., \code{\link[zoo:na.fill]{zoo::na.fill()}} with \code{fill = "extend"})
\item \code{tf_approx_locf} for "last observation carried forward"  (i.e.,
\code{\link[zoo:na.locf]{zoo::na.locf()}} with \code{na.rm = FALSE} and
\item \code{tf_approx_nocb} for "next observation carried backward" (i.e.,
\code{\link[zoo:na.locf]{zoo::na.locf()}} with \verb{na.rm = FALSE, fromLast = TRUE}).
}

For implementing your own, see source code of \code{tf:::zoo_wrapper}.
}
\seealso{
tfd

Other tidyfun inter/extrapolation functions: 
\code{\link{tf_evaluate}()},
\code{\link{tf_interpolate}()}

Other tidyfun inter/extrapolation functions: 
\code{\link{tf_evaluate}()},
\code{\link{tf_interpolate}()}

Other tidyfun inter/extrapolation functions: 
\code{\link{tf_evaluate}()},
\code{\link{tf_interpolate}()}

Other tidyfun inter/extrapolation functions: 
\code{\link{tf_evaluate}()},
\code{\link{tf_interpolate}()}

Other tidyfun inter/extrapolation functions: 
\code{\link{tf_evaluate}()},
\code{\link{tf_interpolate}()}

Other tidyfun inter/extrapolation functions: 
\code{\link{tf_evaluate}()},
\code{\link{tf_interpolate}()}
}
\concept{tidyfun inter/extrapolation functions}
