% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf-package.R
\docType{package}
\name{tf-package}
\alias{tf}
\alias{tf-package}
\title{tf: S3 Classes and Methods for Tidy Functional Data}
\description{
\code{tf} is a light-weight package with few dependencies that
provides the class definitions and methods infrastructure for \code{tidyfun} --
\code{tf} gives you:
\itemize{
\item new S3 data types for representing (vectors of) functional data:
\code{\link[=tfd]{tfd()}} & \code{\link[=tfb]{tfb()}}
\item arithmetic operators for such data (\code{\link[=Ops.tf]{Ops.tf()}}),
\item simple descriptive statistics: e.g. \code{\link[=mean.tf]{mean.tf()}}, \code{\link[=median.tf]{median.tf()}}
\item base graphics functions for such data: \code{\link[=plot.tf]{plot.tf()}}
\item functions to do smoothing (\code{\link[=tf_smooth.tfd]{tf_smooth.tfd()}}),
differentiation \code{\link[=tf_derive.tfd]{tf_derive.tfd()}}) and integration (\code{\link[=tf_derive.tfd]{tf_derive.tfd()}})
}

The goal of the add-on package \code{tidyfun} is to make data wrangling and
exploratory analysis for functional data in \code{R} quick and easy, using
\code{tidyverse} syntax and standards. \cr\cr
Please also install \code{tidyfun} for the full functionality to
access the full documentation including a number of vignettes and case
studies, or visit the \href{https://tidyfun.github.io/tidyfun/}{\code{tidyfun} website}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://tidyfun.github.io/tf/}
  \item \url{https://github.com/tidyfun/tf/}
  \item Report bugs at \url{https://github.com/tidyfun/tf/issues}
}

}
\author{
\strong{Maintainer}: Fabian Scheipl \email{fabian.scheipl@googlemail.com} (\href{https://orcid.org/0000-0001-8172-3603}{ORCID})

Authors:
\itemize{
  \item Jeff Goldsmith
}

Other contributors:
\itemize{
  \item Julia Wrobel (\href{https://orcid.org/0000-0001-6783-1421}{ORCID}) [contributor]
  \item Maximilian Muecke (\href{https://orcid.org/0009-0000-9432-9795}{ORCID}) [contributor]
  \item Sebastian Fischer (\href{https://orcid.org/0000-0002-9609-3197}{ORCID}) [contributor]
  \item Trevor Hastie (softImpute author) [contributor]
  \item Rahul Mazumder (softImpute author) [contributor]
  \item Chen Meng (mogsa author) [contributor]
}

}
\keyword{internal}
