% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_list.R
\name{tidy_list}
\alias{tidy_list}
\title{Tidy a List of Named Dataframes or Named Vectors or Vectors}
\usage{
tidy_list(x, id.name = "id", content.name = "content",
  content.attribute.name = "attribute", ...)
}
\arguments{
\item{x}{A named \code{\link[base]{list}} of
\code{\link[base]{data.frame}}s or \code{\link[base]{vector}}.}

\item{id.name}{The name to use for the column created from the 
\code{\link[base]{list}}.}

\item{content.name}{The name to use for the column created from the 
\code{\link[base]{list}} of \code{\link[base]{vector}}s (only used if 
\code{x} is \code{\link[base]{vector}}).}

\item{content.attribute.name}{The name to use for the column created from the
\code{\link[base]{list}} of names given to the \code{\link[base]{vector}}s
(only used if \code{x} is named \code{\link[base]{vector}}).}

\item{\ldots}{Ignored.}
}
\value{
Returns a \code{\link[data.table]{data.table}} with the 
\code{\link[base]{names}} from the \code{\link[base]{list}} as an \code{id} 
column.
}
\description{
\code{\link[base]{rbind}} a named \code{\link[base]{list}} of
\code{\link[base]{data.frame}}s or \code{\link[base]{vector}}s to
output a single \code{\link[base]{data.frame}} with the 
\code{\link[base]{names}} from the \code{\link[base]{list}} as an \code{id} 
column.
}
\examples{
tidy_list(list(p=1:500, r=letters))
tidy_list(list(p=mtcars, r=mtcars, z=mtcars, d=mtcars))

x <- list(
    a = setNames(c(1:4), LETTERS[1:4]),
    b = setNames(c(7:9), LETTERS[7:9]),
    c = setNames(c(10:15), LETTERS[10:15]),
    d = c(x=4, y=6, 4),
    e = setNames(1:10, sample(state.abb, 10, TRUE)),
    f = setNames(1:10, sample(month.abb, 10, TRUE))
)

tidy_list(x)

\dontrun{
## 2015 Vice-Presidential Debates Example
if (!require("pacman")) install.packages("pacman")
pacman::p_load(rvest, magrittr, xml2)

debates <- c(
    wisconsin = "110908",
    boulder = "110906",
    california = "110756",
    ohio = "110489"
)

lapply(debates, function(x){
    paste0("http://www.presidency.ucsb.edu/ws/index.php?pid=", x) \%>\%
        xml2::read_html() \%>\%
        rvest::html_nodes("p") \%>\%
        rvest::html_text() \%>\%
        textshape::split_index(grep("^[A-Z]+:", .)) \%>\%
        textshape::combine() \%>\%
        textshape::split_transcript() \%>\%
        textshape::split_sentence()
}) \%>\%
    textshape::tidy_list("location")
}
}
