% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_compare.R
\name{pairwise_compare}
\alias{pairwise_compare}
\title{Pairwise comparisons among documents in a corpus}
\usage{
pairwise_compare(corpus, f, ..., directional = FALSE,
  progress = interactive())
}
\arguments{
\item{corpus}{A \code{\link{TextReuseCorpus}}.}

\item{f}{The function to apply to \code{x} and \code{y}.}

\item{...}{Additional arguments passed to \code{f}.}

\item{directional}{Some comparison functions are commutative, so that
\code{f(a, b) == f(b, a)} (e.g., \code{\link{jaccard_similarity}}). Other
functions are directional, so that \code{f(a, b)} measures \code{a}'s
borrowing from \code{b}, which may not be the same as \code{f(b, a)} (e.g.,
\code{\link{ratio_of_matches}}). If \code{directional} is \code{FALSE},
then only the minimum number of comparisons will be made, i.e., the upper
triangle of the matrix. If \code{directional} is \code{TRUE}, then both
directional comparisons will be measured. In no case, however, will
documents be compared to themselves, i.e., the diagonal of the matrix.}

\item{progress}{Display a progress bar while comparing documents.}
}
\value{
A square matrix with dimensions equal to the length of the corpus,
  and row and column names set by the names of the documents in the corpus. A
  value of \code{NA} in the matrix indicates that a comparison was not made.
  In cases of directional comparisons, then the comparison reported is
  \code{f(row, column)}.
}
\description{
Given a \code{\link{TextReuseCorpus}} containing documents of class
\code{\link{TextReuseTextDocument}}, this function applies a comparison
function to every pairing of documents, and returns a matrix with the
comparison scores.
}
\examples{
dir <- system.file("extdata/legal", package = "textreuse")
corpus <- TextReuseCorpus(dir = dir)
names(corpus) <- filenames(names(corpus))

# A non-directional comparison
pairwise_compare(corpus, jaccard_similarity)

# A directional comparison
pairwise_compare(corpus, ratio_of_matches, directional = TRUE)
}
\seealso{
See these document comparison functions,
  \code{\link{jaccard_similarity}}, \code{\link{ratio_of_matches}}.
}

