% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsh_subset.R
\name{lsh_subset}
\alias{lsh_subset}
\title{List of all candidates in a corpus}
\usage{
lsh_subset(candidates)
}
\arguments{
\item{candidates}{A data frame of candidate pairs from
\code{\link{lsh_candidates}}.}
}
\value{
A character vector of document IDs from the candidate pairs, to be
  used to subset the \code{\link{TextReuseCorpus}}.
}
\description{
List of all candidates in a corpus
}
\examples{
dir <- system.file("extdata/legal", package = "textreuse")
minhash <- minhash_generator(200, seed = 234)
corpus <- TextReuseCorpus(dir = dir,
                          tokenizer = tokenize_ngrams, n = 5,
                          minhash_func = minhash)
buckets <- lsh(corpus, bands = 50)
candidates <- lsh_candidates(buckets)
lsh_subset(candidates)
corpus[lsh_subset(candidates)]
}

