% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lemma.R
\name{step_lemma}
\alias{step_lemma}
\title{Lemmatization of Token Variables}
\usage{
step_lemma(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  skip = FALSE,
  id = rand_id("lemma")
)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_lemma} creates a \emph{specification} of a recipe step that will extract the
lemmatization of a \code{\link[=tokenlist]{token}} variable.
}
\details{
This stem doesn't perform lemmatization by itself, but rather lets you
extract the lemma attribute of the \code{\link[=tokenlist]{token}} variable. To be
able to use \code{step_lemma} you need to use a tokenization method that includes
lemmatization. Currently using the \code{"spacyr"} engine in \code{\link[=step_tokenize]{step_tokenize()}}
provides lemmatization and works well with \code{step_lemma}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected).
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontrun{
library(recipes)

short_data <- data.frame(text = c(
  "This is a short tale,",
  "With many cats and ladies."
))

rec_spec <- recipe(~text, data = short_data) \%>\%
  step_tokenize(text, engine = "spacyr") \%>\%
  step_lemma(text) \%>\%
  step_tf(text)

rec_prepped <- prep(rec_spec)

bake(rec_prepped, new_data = NULL)
}

}
\seealso{
\code{\link[=step_tokenize]{step_tokenize()}} to turn characters into \code{\link[=tokenlist]{tokens}}

Other Steps for Token Modification: 
\code{\link{step_ngram}()},
\code{\link{step_pos_filter}()},
\code{\link{step_stem}()},
\code{\link{step_stopwords}()},
\code{\link{step_tokenfilter}()},
\code{\link{step_tokenmerge}()}
}
\concept{Steps for Token Modification}
