% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{topic_table}
\alias{topic_table}
\title{Function to calculate topics and words arrays from the mallet model.}
\usage{
topic_table(model)
}
\arguments{
\item{model}{tmTopicModel mallet type model.}
}
\value{
topics Array of the topics.

words Array of the most important words in topic.
}
\description{
Function to calculate topics and words arrays from the mallet model.
}
\examples{
\dontrun{
library(rJava)
x <- tmCorpus(lapply(1:100, function(x) paste(sample(LETTERS, 11),
                                              collapse = "")))

model <- train(x)
new_x <- tmCorpus(lapply(1:100, function(x) paste(sample(LETTERS, 11),
                                                  collapse = "")))


topic_table(model)

y <- DocumentTermMatrix(x)
rownames(y) <- meta(x, "title")
jss_TM <-
  list(VEM = train(y, k = k, control = list(seed = SEED)),
       VEM_fixed = train(y, k = k,
                         control = list(estimate.alpha = FALSE, seed = SEED)),
       Gibbs = train(y, k = k, method = "Gibbs",
                     control = list(seed = SEED, burnin = 1000,
                                    thin = 100, iter = 1000)))
pred_VEM <- predict(jss_TM$VEM, new_x)
}
}

