% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbCoherence.R
\name{ProbCoherence}
\alias{ProbCoherence}
\title{Probailistic coherence of topics}
\usage{
ProbCoherence(topic, dtm, M = 5)
}
\arguments{
\item{topic}{A probability vector denoting a relationship between words 
and a topic. This may be p(word|topic) or p(topic|word)}

\item{dtm}{A document term matrix of class Matrix. Columns index words; 
rows index documents}

\item{M}{An integer for the number of words to be used in the calculation. 
Defaults to 5}
}
\value{
Returns an object of class \code{numeric} corresponding to the 
probabilistic coherence of the input topic.
}
\description{
Calculates the probabilistic coherence of a topic. This 
approximates semmantic coherence or human understandability of a topic.
}
\examples{
# Load a pre-formatted dtm and topic model
data(nih_sample_topic_model) 
data(nih_sample_dtm)

# Coherence of topic 1
ProbCoherence(topic = nih_sample_topic_model$phi[ 1 , ], dtm = nih_sample_dtm, M = 5)

}

