% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_kerning.R
\name{replace_kern}
\alias{replace_kern}
\title{Replace Kerned (Spaced) with No Space Version}
\usage{
replace_kern(x, ...)
}
\arguments{
\item{x}{The text variable.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector with kern spaces removed.
}
\description{
In typography kerning is the adjustment of spacing.  Often, in informal 
writing, adding manual spaces (a form of kerning) coupled with all capital 
letters is used for emphasis.  This tool looks for 3 or more consecutive 
capital letters with spaces in between and removes the spaces.  Essentially, 
the capitalized, kerned version is replaced with the word equivalent.
}
\examples{
x <- c(
    "Welcome to A I: the best W O R L D!",
    "Hi I R is the B O M B for sure: we A G R E E indeed.",
    "A sort C A T indeed!",
    NA
)

replace_kern(x)
}
\references{
\url{https://stackoverflow.com/a/47438305/1000343}
}
\author{
StackOverflow user @ctwheels
}
