% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{ifiles}
\alias{idir}
\alias{ifiles}
\title{Creates iterator over text/serialized files from the disk}
\usage{
ifiles(file_paths, serialized = FALSE, reader_function = read_lines, ...)

idir(path, serialized = FALSE, reader_function = read_lines, ...)
}
\arguments{
\item{file_paths}{\code{character} paths of input files}

\item{serialized}{\code{logical} indicates, whether to read raw text files or
pre-tokenized list of character vectors, saved to disk in serialized form (.RData, .rds files).}

\item{reader_function}{\code{function} which will perform reading of text files from disk.
Only one assumption - it should take path as first argument.}

\item{...}{arguments passed to other methods (inculding \code{reader_function}).}

\item{path}{\code{character} path of directory, from where read ALL the files.}
}
\description{
Result of this function usually used in \link{itoken} function.
}
\examples{
current_dir_files <- list.files(path = ".", full.names = TRUE)
files_iterator <- ifiles(current_dir_files)
dir_files_iterator <- idir(path = ".")
}
\seealso{
\link{itoken}
}

