% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_4_textPlotWordPrediction.R
\name{textWordPrediction}
\alias{textWordPrediction}
\title{Compute predictions based on single words for plotting words. The word embeddings of
single words are trained to predict the mean value associated with that word. P-values does
NOT work yet (experimental).}
\usage{
textWordPrediction(
  words,
  word_types_embeddings = word_types_embeddings_df,
  x,
  y = NULL,
  seed = 1003,
  case_insensitive = TRUE,
  text_remove = "[()]",
  ...
)
}
\arguments{
\item{words}{Word or text variable to be plotted.}

\item{word_types_embeddings}{Word embeddings from textEmbed for individual words
(i.e., decontextualized embeddings).}

\item{x}{Numeric variable that the words should be plotted according to on the x-axes.}

\item{y}{Numeric variable that the words should be plotted according to on the y-axes (y=NULL).}

\item{seed}{Set different seed.}

\item{case_insensitive}{When TRUE all words are made lower case.}

\item{text_remove}{Remove special characters}

\item{...}{Training options from textTrainRegression().}
}
\value{
A dataframe with variables (e.g., including trained (out of sample) predictions, frequencies, p-values)
for the individual words that is used for the plotting in the textProjectionPlot function.
}
\description{
Compute predictions based on single words for plotting words. The word embeddings of
single words are trained to predict the mean value associated with that word. P-values does
NOT work yet (experimental).
}
\examples{
# Data
# Pre-processing data for plotting
\dontrun{
df_for_plotting <- textWordPrediction(
  words = Language_based_assessment_data_8$harmonywords,
  word_types_embeddings = word_embeddings_4$word_types,
  x = Language_based_assessment_data_8$hilstotal
)
df_for_plotting
}
#' @seealso see \code{\link{textProjection}}
}
