% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,clm-method}
\alias{extract,clm-method}
\alias{extract.clm}
\title{\code{\link{extract}} method for \code{clm} objects}
\usage{
\S4method{extract}{clm}(
  model,
  include.thresholds = TRUE,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.nobs = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.thresholds}{Report thresholds in the GOF block?}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{clm} objects created by the
\code{\link[ordinal]{clm}} function in the \pkg{ordinal} package.
}
