% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-tools.R
\name{get_wrapper_type}
\alias{get_wrapper_type}
\title{Get the name of the wrapper file in the article dir}
\usage{
get_wrapper_type(article_dir)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}
}
\value{
String with name of wrapper file or empty
}
\description{
This function gets the wrapper file name from the
commonly named R-Journal wrapper files.
}
\details{
Usually the R journal wrapper files are named either
1. RJwrapper.tex
2. RJwrap.tex
3. wrapper.tex
}
\examples{
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
texor::get_wrapper_type(your_article_path)
unlink(your_article_folder,recursive = TRUE)
}
