% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evmBoot.R
\name{evmBoot}
\alias{coef.evmBoot}
\alias{evmBoot}
\alias{plot.evmBoot}
\alias{print.evmBoot}
\alias{print.summary.evmBoot}
\alias{summary.evmBoot}
\title{Bootstrap an evmOpt fit}
\usage{
evmBoot(o, R=1000, trace=100, cores=NULL, theCall)
\method{summary}{evmBoot}(object,...)
\method{plot}{evmBoot}(x,col=4,border=NULL,...)
\method{coef}{evmBoot}(object,...)
\method{print}{summary.evmBoot}(x,...)
\method{print}{evmBoot}(x,...)
}
\arguments{
\item{o}{a fit \code{evmOpt} object}

\item{R}{the number of parametric bootstrap samples to run}

\item{trace}{the frequency of trace messages}

\item{cores}{The number of coresto use when bootstrapping. Defaults
to \code{cores=NULL} and the function guesses how many cores
are available and uses them all.}

\item{theCall}{(for internal use)}

\item{...}{Arguments passed to \code{ggplot}. Not used.}

\item{x}{An object of class 'evmBoot'.}

\item{object}{An object of class 'evmBoot'.}

\item{col}{Colour to be used in plotting. Defaults to \code{col=4}.}

\item{border}{Border colour for histogram. Defaults to \code{border=NULL}.}
}
\value{
An object of class \code{evmBoot}; a list with
\item{call}{The call to \code{evmBoot} that produced the object.}
\item{replicates}{The parameter estimates from the bootstrap fits.}
\item{map}{The fit by by maximum penalized likelihood to the original data.}
}
\description{
This runs a parametric bootstrap simulating from an optimized
model.
}
\note{
It is not expected that a user will need to call
    this function directly; you are directed to \code{\link{evm}}.
}
\seealso{
\code{\link{evm}}
}

