% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-match.R
\name{expect_match}
\alias{expect_match}
\alias{expect_no_match}
\title{Do you expect a string to match this pattern?}
\usage{
expect_match(
  object,
  regexp,
  perl = FALSE,
  fixed = FALSE,
  ...,
  all = TRUE,
  info = NULL,
  label = NULL
)

expect_no_match(
  object,
  regexp,
  perl = FALSE,
  fixed = FALSE,
  ...,
  all = TRUE,
  info = NULL,
  label = NULL
)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}

\item{regexp}{Regular expression to test against.}

\item{perl}{logical.  Should Perl-compatible regexps be used?}

\item{fixed}{If \code{TRUE}, treats \code{regexp} as a string to be matched exactly
(not a regular expressions). Overrides \code{perl}.}

\item{...}{
  Arguments passed on to \code{\link[base:grep]{base::grepl}}
  \describe{
    \item{\code{ignore.case}}{logical. if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}
    \item{\code{useBytes}}{logical.  If \code{TRUE} the matching is done
    byte-by-byte rather than character-by-character.  See
    \sQuote{Details}.}
  }}

\item{all}{Should all elements of actual value match \code{regexp} (TRUE),
or does only one need to match (FALSE).}

\item{info}{Extra information to be included in the message. This argument
is soft-deprecated and should not be used in new code. Instead see
alternatives in \link{quasi_label}.}

\item{label}{Used to customise failure messages. For expert use only.}
}
\description{
Do you expect a string to match this pattern?
}
\details{
\code{expect_match()} checks if a character vector matches a regular expression,
powered by \code{\link[=grepl]{grepl()}}.

\code{expect_no_match()} provides the complementary case, checking that a
character vector \emph{does not} match a regular expression.
}
\section{Functions}{
\itemize{
\item \code{expect_no_match()}: Check that a string doesn't match a regular
expression.

}}
\examples{
expect_match("Testing is fun", "fun")
expect_match("Testing is fun", "f.n")
expect_no_match("Testing is fun", "horrible")

show_failure(expect_match("Testing is fun", "horrible"))
show_failure(expect_match("Testing is fun", "horrible", fixed = TRUE))

# Zero-length inputs always fail
show_failure(expect_match(character(), "."))
}
\seealso{
Other expectations: 
\code{\link{comparison-expectations}},
\code{\link{equality-expectations}},
\code{\link{expect_error}()},
\code{\link{expect_length}()},
\code{\link{expect_named}()},
\code{\link{expect_null}()},
\code{\link{expect_output}()},
\code{\link{expect_reference}()},
\code{\link{expect_silent}()},
\code{\link{inheritance-expectations}},
\code{\link{logical-expectations}}
}
\concept{expectations}
