% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teardown.R
\name{teardown}
\alias{teardown}
\alias{setup}
\title{Run code on setup/teardown}
\usage{
teardown(code, env = parent.frame())

setup(code, env = parent.frame())
}
\arguments{
\item{code}{Code to evaluate}

\item{env}{Environment in which code will be evaluted. For expert
use only.}
}
\description{
Code in a \code{setup()} block is run immediately in a clean environment.
Code in a \code{teardown()} block is run upon completion of a test file,
even if it exits with an error. Multiple calls to \code{teardown()} will be
executed in the order they were created.
}
\examples{
\dontrun{

tmp <- tempfile()
setup(writeLines(tmp, "some test data"))
teardown(unlink(tmp))

}
}
