% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_time_complexity.R
\name{expect_time_complexity}
\alias{expect_time_complexity}
\title{Expected Time Complexity Test function}
\usage{
expect_time_complexity(complexity.class, ..., f)
}
\arguments{
\item{complexity.class}{A string denoting the expected complexity class}

\item{...}{Parameters for passed function 'f'.}

\item{f}{A function which returns a data frame composed of timings and corresponding data sizes, ideally from asymptoticTimings. (can use other functions)}
}
\value{
null for expected complexity, else throws error.
}
\description{
Function to test if input algorithm has the specified time complexity
}
\details{
For more information regarding its implementation or functionality/usage, please check https://anirban166.github.io//Testing-functions/
}
\examples{
\dontrun{
# Running the quick sort algorithm with sampling against a set of increasing input data sizes:
ds = 10^seq(1, 3, by = 0.5)
# Assigning a complexity class to test against:
cc = "loglinear"
# Note: short variable names are used to avoid exceeding the character limit in the line below.
expect_time_complexity(cc, sort(sample(1:100, data.sizes, replace = TRUE), method = "quick"), ds)
# The code above will throw an error if the function does not follow a log-linear trend.
}
}
