% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{plotVoronoiDiagram}
\alias{plotVoronoiDiagram}
\title{Plot Voronoï diagram}
\usage{
plotVoronoiDiagram(
  v,
  colors = "random",
  distinctArgs = list(seedcolors = c("#ff0000", "#00ff00", "#0000ff")),
  randomArgs = list(hue = "random", luminosity = "bright"),
  alpha = 1,
  ...
)
}
\arguments{
\item{v}{an output of \code{\link{voronoi}}}

\item{colors}{this can be \code{"random"} to use random colors for the cells
with \code{\link[colorsGen]{randomColor}}, \code{"distinct"} to use
distinct colors with the help of
\code{\link[Polychrome]{createPalette}}, or this can be \code{NA}
for no colors, or a vector of colors; the length of this vector
of colors must match the number of bounded cells, which is displayed when
you run the \code{\link{voronoi}} function and that you can also get by
typing \code{attr(v, "nbounded")}}

\item{distinctArgs}{if \code{colors = "distinct"}, a list of arguments
passed to \code{\link[Polychrome]{createPalette}}}

\item{randomArgs}{if \code{colors = "random"}, a list of arguments passed
to \code{\link[colorsGen]{randomColor}}}

\item{alpha}{opacity, a number between 0 and 1
(used when \code{colors} is not \code{NA})}

\item{...}{arguments passed to \code{\link{plotBoundedCell2D}} or
\code{\link{plotBoundedCell3D}}}
}
\value{
No returned value.
}
\description{
Plot all the bounded cells of a 2D or 3D Voronoï tessellation.
}
\note{
Sometimes, it is necessary to set the option \code{degenerate=TRUE}
  in the \code{\link{delaunay}} function in order to get a correct
  Voronoï diagram with the \code{plotVoronoiDiagram} function (I don't know
  why).
}
\examples{
library(tessellation)
# 2D example: Fermat spiral
theta <- seq(0, 100, length.out = 300L)
x <- sqrt(theta) * cos(theta)
y <- sqrt(theta) * sin(theta)
pts <- cbind(x,y)
opar <- par(mar = c(0, 0, 0, 0), bg = "black")
# Here is a Fermat spiral:
plot(pts, asp = 1, xlab = NA, ylab = NA, axes = FALSE, pch = 19, col = "white")
# And here is its Voronoï diagram:
plot(NULL, asp = 1, xlim = c(-15, 15), ylim = c(-15, 15),
     xlab = NA, ylab = NA, axes = FALSE)
del <- delaunay(pts)
v <- voronoi(del)
length(Filter(isBoundedCell, v)) # 281 bounded cells
plotVoronoiDiagram(v, colors = viridisLite::turbo(281L))
par(opar)

# 3D example: tetrahedron surrounded by three circles
tetrahedron <-
  rbind(
    c(2*sqrt(2)/3, 0, -1/3),
    c(-sqrt(2)/3, sqrt(2/3), -1/3),
    c(-sqrt(2)/3, -sqrt(2/3), -1/3),
    c(0, 0, 1)
  )
angles <- seq(0, 2*pi, length.out = 91)[-1]
R <- 2.5
circle1 <- t(vapply(angles, function(a) R*c(cos(a), sin(a), 0), numeric(3L)))
circle2 <- t(vapply(angles, function(a) R*c(cos(a), 0, sin(a)), numeric(3L)))
circle3 <- t(vapply(angles, function(a) R*c(0, cos(a), sin(a)), numeric(3L)))
circles <- rbind(circle1, circle2, circle3)
pts <- rbind(tetrahedron, circles)
d <- delaunay(pts, degenerate = TRUE)
v <- voronoi(d)
library(rgl)
open3d(windowRect = c(50, 50, 562, 562))
material3d(lwd = 2)
\donttest{plotVoronoiDiagram(v)}
}
