% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_adsl_adlb_merge_using_worst_flag.R
\name{h_adsl_adlb_merge_using_worst_flag}
\alias{h_adsl_adlb_merge_using_worst_flag}
\title{Helper function for deriving analysis datasets for select laboratory tables}
\usage{
h_adsl_adlb_merge_using_worst_flag(
  adsl,
  adlb,
  worst_flag = c(WGRHIFL = "Y"),
  by_visit = FALSE,
  no_fillin_visits = c("SCREENING", "BASELINE")
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr ADSL data frame.}

\item{adlb}{(\code{data.frame})\cr ADLB data frame.}

\item{worst_flag}{(named \code{character})\cr worst post-baseline lab flag variable. See how this is implemented in the
following examples.}

\item{by_visit}{(\code{flag})\cr defaults to \code{FALSE} to generate worst grade per patient.
If worst grade per patient per visit is specified for \code{worst_flag}, then
\code{by_visit} should be \code{TRUE} to generate worst grade patient per visit.}

\item{no_fillin_visits}{(named \code{character})\cr visits that are not considered for post-baseline worst toxicity
grade. Defaults to \code{c("SCREENING", "BASELINE")}.}
}
\value{
\code{df} containing variables shared between \code{adlb} and \code{adsl} along with variables \code{PARAM}, \code{PARAMCD},
\code{ATOXGR}, and \code{BTOXGR} relevant for analysis. Optionally, \code{AVISIT} are \code{AVISITN} are included when
\code{by_visit = TRUE} and \code{no_fillin_visits = c("SCREENING", "BASELINE")}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper function that merges ADSL and ADLB datasets so that missing lab test records are inserted in the
output dataset. Remember that \code{na_level} must match the needed pre-processing
done with \code{\link[=df_explicit_na]{df_explicit_na()}} to have the desired output.
}
\details{
In the result data missing records will be created for the following situations:
\itemize{
\item Patients who are present in \code{adsl} but have no lab data in \code{adlb} (both baseline and post-baseline).
\item Patients who do not have any post-baseline lab values.
\item Patients without any post-baseline values flagged as the worst.
}
}
\examples{
# `h_adsl_adlb_merge_using_worst_flag`
adlb_out <- h_adsl_adlb_merge_using_worst_flag(
  tern_ex_adsl,
  tern_ex_adlb,
  worst_flag = c("WGRHIFL" = "Y")
)

# `h_adsl_adlb_merge_using_worst_flag` by visit example
adlb_out_by_visit <- h_adsl_adlb_merge_using_worst_flag(
  tern_ex_adsl,
  tern_ex_adlb,
  worst_flag = c("WGRLOVFL" = "Y"),
  by_visit = TRUE
)

}
