% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskdiff.R
\name{add_riskdiff}
\alias{add_riskdiff}
\title{Split Function to Configure Risk Difference Column}
\usage{
add_riskdiff(
  arm_x,
  arm_y,
  col_label = paste0("Risk Difference (\%) (95\% CI)", if (length(arm_y) > 1)
    paste0("\\n", arm_x, " vs. ", arm_y)),
  pct = TRUE
)
}
\arguments{
\item{arm_x}{(\code{character})\cr Name of reference arm to use in risk difference calculations.}

\item{arm_y}{(\code{character})\cr Names of one or more arms to compare to reference arm in risk difference
calculations. A new column will be added for each value of \code{arm_y}.}

\item{col_label}{(\code{character})\cr Labels to use when rendering the risk difference column within the table.
If more than one comparison arm is specified in \code{arm_y}, default labels will specify which two arms are
being compared (reference arm vs. comparison arm).}

\item{pct}{(\code{flag})\cr whether output should be returned as percentages. Defaults to \code{TRUE}.}
}
\value{
A closure suitable for use as a split function (\code{split_fun}) within \code{\link[rtables:split_cols_by]{rtables::split_cols_by()}}
when creating a table layout.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Wrapper function for \code{\link[rtables:add_combo_levels]{rtables::add_combo_levels()}} which configures settings for the risk difference
column to be added to an \code{rtables} object. To add a risk difference column to a table, this function
should be used as \code{split_fun} in calls to \code{\link[rtables:split_cols_by]{rtables::split_cols_by()}}, followed by setting argument
\code{riskdiff} to \code{TRUE} in all following analyze function calls.
}
\examples{
adae <- tern_ex_adae
adae$AESEV <- factor(adae$AESEV)

lyt <- basic_table() \%>\%
  split_cols_by("ARMCD", split_fun = add_riskdiff(arm_x = "ARM A", arm_y = c("ARM B", "ARM C"))) \%>\%
  count_occurrences_by_grade(
    var = "AESEV",
    riskdiff = TRUE
  )

tbl <- build_table(lyt, df = adae)
tbl

}
\seealso{
\code{\link[=stat_propdiff_ci]{stat_propdiff_ci()}} for details on risk difference calculation.
}
