% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph.R
\name{try_car_anova}
\alias{try_car_anova}
\title{\code{tryCatch} around \code{car::Anova}}
\usage{
try_car_anova(mod, test.statistic)
}
\arguments{
\item{mod}{\code{lm}, \code{aov}, \code{glm}, \code{multinom}, \code{polr}
    \code{mlm}, \code{coxph}, \code{coxme}, \code{lme}, \code{mer}, \code{merMod}, \code{svyglm}, \code{svycoxph},
    \code{rlm}, or other suitable model object.}

\item{test.statistic}{for a generalized linear model, whether to calculate
    \code{"LR"} (likelihood-ratio), \code{"Wald"}, or \code{"F"} tests; for a Cox
    or Cox mixed-effects model, whether to calculate \code{"LR"} (partial-likelihood ratio) or
    \code{"Wald"} tests; in the default case or for linear mixed models fit by
    \code{lmer}, whether to calculate Wald \code{"Chisq"} or Kenward-Roger
    \code{"F"} tests with Satterthwaite degrees of freedom (\emph{warning:} the KR F-tests
    can be very time-consuming).
    For a multivariate linear model, the multivariate test statistic to compute --- one of
    \code{"Pillai"}, \code{"Wilks"}, \code{"Hotelling-Lawley"}, or \code{"Roy"},
    with \code{"Pillai"} as the default. The \code{summary} method for \code{Anova.mlm}
    objects permits the specification of more than one multivariate
    test statistic, and the default is to report all four.}
}
\value{
A list with item \code{aov} for the result of the model and \code{error_text} for the captured warnings.
}
\description{
Captures warnings when executing \link[car:Anova]{car::Anova}.
}
\examples{
# `car::Anova` on cox regression model including strata and expected
# a likelihood ratio test triggers a warning as only `Wald` method is
# accepted.

library(survival)

mod <- coxph(
  formula = Surv(time = futime, event = fustat) ~ factor(rx) + strata(ecog.ps),
  data = ovarian
)

}
\keyword{internal}
