% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_response_biomarkers_subgroups.R
\name{h_response_biomarkers_subgroups}
\alias{h_response_biomarkers_subgroups}
\alias{h_rsp_to_logistic_variables}
\alias{h_logistic_mult_cont_df}
\alias{h_tab_rsp_one_biomarker}
\title{Helper Functions for Tabulating Biomarker Effects on Binary Response by Subgroup}
\usage{
h_rsp_to_logistic_variables(variables, biomarker)

h_logistic_mult_cont_df(variables, data, control = control_logistic())

h_tab_rsp_one_biomarker(df, vars, .indent_mods = 0L)
}
\arguments{
\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{biomarker}{(\code{string})\cr the name of the biomarker variable.}

\item{data}{(\code{data.frame})\cr the dataset containing the variables to summarize.}

\item{control}{(named \code{list})\cr controls for the response definition and the
confidence level produced by \code{\link[=control_logistic]{control_logistic()}}.}

\item{df}{(\code{data.frame})\cr results for a single biomarker, as part of what is
returned by \code{\link[=extract_rsp_biomarkers]{extract_rsp_biomarkers()}} (it needs a couple of columns which are
added by that high-level function relative to what is returned by \code{\link[=h_logistic_mult_cont_df]{h_logistic_mult_cont_df()}},
see the example).}

\item{vars}{(\code{character})\cr the names of statistics to be reported among:
\itemize{
\item \code{n_tot}: Total number of patients per group.
\item \code{n_rsp}: Total number of responses per group.
\item \code{prop}: Total response proportion per group.
\item \code{or}: Odds ratio.
\item \code{ci}: Confidence interval of odds ratio.
\item \code{pval}: p-value of the effect.
Note, the statistics \code{n_tot}, \code{or} and \code{ci} are required.
}}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
\itemize{
\item \code{h_rsp_to_logistic_variables()} returns a named \code{list} of elements \code{response}, \code{arm}, \code{covariates}, and \code{strata}.
}

\itemize{
\item \code{h_logistic_mult_cont_df()} returns a \code{data.frame} containing estimates and statistics for the selected biomarkers.
}

\itemize{
\item \code{h_tab_rsp_one_biomarker()} returns an \code{rtables} table object with the given statistics arranged in columns.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper functions which are documented here separately to not confuse the user
when reading about the user-facing functions.
}
\section{Functions}{
\itemize{
\item \code{h_rsp_to_logistic_variables()}: helps with converting the "response" function variable list
to the "logistic regression" variable list. The reason is that currently there is an
inconsistency between the variable names accepted by \code{extract_rsp_subgroups()} and \code{fit_logistic()}.

\item \code{h_logistic_mult_cont_df()}: prepares estimates for number of responses, patients and
overall response rate, as well as odds ratio estimates, confidence intervals and p-values, for multiple
biomarkers in a given single data set.
\code{variables} corresponds to names of variables found in \code{data}, passed as a named list and requires elements
\code{rsp} and \code{biomarkers} (vector of continuous biomarker variables) and optionally \code{covariates}
and \code{strat}.

\item \code{h_tab_rsp_one_biomarker()}: prepares a single sub-table given a \code{df_sub} containing
the results for a single biomarker.

}}
\examples{
library(dplyr)
library(forcats)

adrs <- tern_ex_adrs
adrs_labels <- formatters::var_labels(adrs)

adrs_f <- adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  mutate(rsp = AVALC == "CR")
formatters::var_labels(adrs_f) <- c(adrs_labels, "Response")

# This is how the variable list is converted internally.
h_rsp_to_logistic_variables(
  variables = list(
    rsp = "RSP",
    covariates = c("A", "B"),
    strat = "D"
  ),
  biomarker = "AGE"
)

# For a single population, estimate separately the effects
# of two biomarkers.
df <- h_logistic_mult_cont_df(
  variables = list(
    rsp = "rsp",
    biomarkers = c("BMRKR1", "AGE"),
    covariates = "SEX"
  ),
  data = adrs_f
)
df

# If the data set is empty, still the corresponding rows with missings are returned.
h_coxreg_mult_cont_df(
  variables = list(
    rsp = "rsp",
    biomarkers = c("BMRKR1", "AGE"),
    covariates = "SEX",
    strat = "STRATA1"
  ),
  data = adrs_f[NULL, ]
)

# Starting from above `df`, zoom in on one biomarker and add required columns.
df1 <- df[1, ]
df1$subgroup <- "All patients"
df1$row_type <- "content"
df1$var <- "ALL"
df1$var_label <- "All patients"

h_tab_rsp_one_biomarker(
  df1,
  vars = c("n_tot", "n_rsp", "prop", "or", "ci", "pval")
)

}
