% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgroups.R
\name{tabulate_mmrm_subgroups}
\alias{tabulate_mmrm_subgroups}
\title{Tabulation of MMRM Subgroups Results}
\usage{
tabulate_mmrm_subgroups(
  lyt,
  df,
  vars = c("n_tot", "n", "lsmean", "diff", "ci"),
  .formats = list(n = "xx", n_tot = "xx", lsmean = "xx.x", diff = "xx.x", ci =
    "(xx.x, xx.x)", pval = "x.xxxx | (<0.0001)"),
  .labels = list(n = "n", n_tot = "Total n", lsmean = "Mean", diff = "Mean Difference",
    ci = paste0(round(100 * df$contrasts$conf_level[1]), "\% CI"), pval = "p-value")
)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{df}{(\code{list})\cr of data frames containing all analysis variables, is the
result from \code{\link[=extract_mmrm_subgroups]{extract_mmrm_subgroups()}}.}

\item{vars}{(\code{character})\cr the name of statistics to be reported among
\code{n_tot} (total number of patients per group),
\code{n} (number of patients per treatment arm and group),
\code{lsmean} (least square mean point estimate),
\code{diff} (difference of least square mean estimates between treatment and reference arm),
\code{ci} (confidence interval of difference) and
\code{pval} (p value of the \code{diff}, not adjusted for multiple comparisons).
Note, the statistics \code{n_tot}, \code{diff} and \code{ci} are required.}

\item{.formats}{(named \code{list})\cr containing the formats for the statistics.}

\item{.labels}{(named \code{list})\cr containing the labels for the statistics.}
}
\value{
The \code{rtables} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function tabulates the results from \code{\link[=extract_mmrm_subgroups]{extract_mmrm_subgroups()}}.
}
\examples{
mmrm_results <- fit_mmrm(
  vars = list(
    response = "FEV1",
    covariates = "RACE",
    id = "USUBJID",
    arm = "ARMCD",
    visit = "AVISIT"
  ),
  data = mmrm_test_data,
  cor_struct = "compound symmetry",
  weights_emmeans = "equal",
  averages_emmeans = list(
    "VIS1+2" = c("VIS1", "VIS2")
  )
)

df <- extract_mmrm_subgroups(
  fit = mmrm_results,
  visit = "VIS3",
  subgroups = c("RACE", "SEX")
)

## Table with default columns.
basic_table() \%>\%
  tabulate_mmrm_subgroups(df)

## Table with selected columns.
tab <- basic_table() \%>\%
  tabulate_mmrm_subgroups(
    df = df,
    vars = c("n_tot", "diff", "ci", "pval")
  )
tab

## Forest plot can be produced based on this very easily.
g_forest(tab, logx = FALSE, xlim = c(-10, 10), x_at = c(-10, -5, 0, 5, 10), vline = 0)
}
