% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.data4.R
\name{get.data4}
\alias{get.data4}
\title{Generate a random 4th-order tensor}
\usage{
get.data4(n, p, q, s, k = NULL, r = NULL, l = NULL, m = NULL,
  error = 3, sort = TRUE, sparse.percent = 0, center = FALSE,
  seed = NULL, mumin = -3, mumax = 3)
}
\arguments{
\item{n}{the dimension of mode 1}

\item{p}{the dimension of mode 2}

\item{q}{the dimension of mode 3}

\item{s}{the dimension of mode 4}

\item{k}{\eqn{d_1}: the clusters number of mode 1}

\item{r}{\eqn{d_2}: the clusters number of mode 2}

\item{l}{\eqn{d_3}: the clusters number of mode 3}

\item{m}{\eqn{d_4}: the clusters number of mode 4}

\item{error}{positive numeric value: the noise in rnorm()}

\item{sort}{if TRUE, the data belongs to the same clusters would assemble together after sorting}

\item{sparse.percent}{the proportion of 0 mean in normal case; the proportion of 0 of each vector in multiplicative case}

\item{center}{logic value that indicates whether run "x = x-mean(x)" before performing clustering.}

\item{seed}{default is NULL, otherwise would set seed to corresponding point}

\item{mumin}{numeric value. The lower bound of mu when sampling mu}

\item{mumax}{numeric value. The lower bound of mu when sampling mu}
}
\value{
a list \code{x} the tensor   

               \code{truthX} the tensor before adding the noise   
               
               \code{truthCs} true distribution in mode 1   
               
               \code{truthDs} true distribution in mode 2   
               
               \code{truthEs} true distribution in mode 3   
               
               \code{mus} the mean signal of all clusters   
               
               \code{binaryX} the 0-1 tensor (0:the mean signal = 0; 1:the mean signal != 0)
}
\description{
Generate a random 4th-order tensor.
}
