% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normSlabScaling}
\alias{normSlabScaling}
\title{Preprocessing: Slab Scaling}
\usage{
normSlabScaling(Y, o = 2)
}
\arguments{
\item{Y}{the tensor data. See function \code{\link{tensorBF}} for
details.}

\item{o}{the \eqn{o^{th}} (default: 2) mode of the tensor in which the slabs are to be scaled to unit variance.}
}
\value{
a list containing the following elements:
\item{data}{The data after performing the required scaling operation.}
\item{pre}{The scale's used for preprocessing.}
}
\description{
\code{normSlabScaling} scales the slabs of the \eqn{o^{th}} mode of the tensor to unit variance.
}
\examples{
#Data generation
K <- 3
X <- matrix(rnorm(20*K),20,K)
W <- matrix(rnorm(30*K),30,K)
U <- matrix(rnorm(3*K),3,K)
Y = 0
for(k in 1:K) Y <- Y + outer(outer(X[,k],W[,k]),U[,k])
 Y <- Y + array(rnorm(20*30*3),dim=c(20,30,3))

#scale the slabs in second mode of tensor Y
res <- normSlabScaling(Y=Y,o=2)
dim(res$data) #the scaled data
}
\references{
Kolda, Tamara G., and Brett W. Bader. "Tensor decompositions and applications." SIAM review 51.3 (2009): 455-500.
}

