% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{plot_pca.trajectories}
\alias{plot_pca.trajectories}
\title{Plot trajectories based on Temporal Check-All-That-Apply (TCATA) data}
\usage{
plot_pca.trajectories(in.pca = in.pca, products.times = matrix(NA),
attributes = c(), type = "smooth", span = 0.75, biplot = "distance",
flip = c(FALSE, FALSE), dims = c(1, 2),
att.offset.x = c(), att.offset.y = c(), inflate.factor = NA,
xlab = "_auto_", ylab = "_auto_", xlim = NULL, ylim = NULL,
attributes.col = "red", attributes.pch = 17,
lwd = 1, traj.lab.loc = 0, traj.col = c(grDevices::grey(1/2)), traj.points = NA,
traj.col.seg = NA, traj.cex = 1, traj.lab = c(), traj.lab.cex = 1,
arrow.loc = NA, arrow.length = 0.1, arrow.col = NA, arrow.lwd = NA,
contrails = list(), main = "", save.format = "eps", save.as = "")
}
\arguments{
\item{in.pca}{Any \code{list} object with components \code{sdev}, \code{rotation}, and \code{x}. Most often it is a \code{prcomp} object obtained from PCA on a matrix of proportions (or, if there is no missing data, on counts) with Product*Times in rows and Attributes in columns.}

\item{products.times}{a 2-column matrix, with an ascending sort order on products (column 1) and a secondary ascending sort on times (column 2), corresponding to the rows of the matrix submitted to prcomp to obtain \code{"in.pca"}.}

\item{attributes}{a vector of attribute labels, corresponding to the attributes of the matrix submitted to prcomp to obtain \code{"in.pca"}.}

\item{type}{Determines how trajectories are drawn. Possible values are \code{"smooth"} (default) or \code{"raw"}.}

\item{span}{A tuning parameter used if smoothing trajectories using the \code{loess} function.}

\item{biplot}{Controls the type of biplot displayed. Possible values are \code{"distance"} (plots trajectories based on scores, and attributes based on eigenvectors multiplied by the \code{"inflation.factor"}), or \code{"correlation"} (plots trajectories based on scores divided by the sqrt of their respective eigenvalues, and attributes based on eigenvectors multiplied by the sqrt of their respective eigenvalues).}

\item{flip}{a vector of two logical values. Value indicates whether to mirror the coordinates in the x and y dimensions respectively. Default is \code{c(FALSE, FALSE)}.}

\item{dims}{a vector of two integers, specifying the principal componts to display. Defaults is \code{"c(1, 2)"}, i.e. PC1 vs. PC2.}

\item{att.offset.x}{A vector of numeric values corresponding to the labels in \code{"attributes"}. Used to adjust the horizontal position of attribute labels to make the plot more readable.}

\item{att.offset.y}{A vector of numeric values corresponding to the labels in \code{"attributes"}. Used to adjust the vertical position of attribute labels to make the plot more readable.}

\item{inflate.factor}{Scalar controlling the position of attribute labels. If \code{"NA"} (default), then this scalar is set to the largest absolute score divided by the largest absolute eigenvector based on the dimensions used. Use \code{"1"} for no inflation. Applies only when \code{biplot = "distance"}.}

\item{xlab}{Label for x axis.}

\item{ylab}{Label for y axis.}

\item{xlim}{Permits control of the x limit. Limits can be specified using a vector of 2 (ascending) numbers. If a single number is provided then values are selected such that the limits are 20\% beyond the smallest and largest x coordinates, respectively. If unspecified then control over x axis limits is given to the plot function in R.}

\item{ylim}{Permits control of the x limit using the same logic as is used for \code{"xlim"}.}

\item{attributes.col}{Color used to display attribute labels (see \code{"attributes"}).}

\item{attributes.pch}{Symbol for attribute coordinates.}

\item{lwd}{Trajectory line width.}

\item{traj.lab.loc}{Indicates where along the trajectory the trajectory label will be positioned. \code{"1"} indicates the start of the trajectory. The value \code{"0"} (default) is a special convention indicating the end of the trajectory.}

\item{traj.col}{A vector of colors for trajectories. If not specified then all trajectories are shown in grey.}

\item{traj.points}{Specifies the position of markers along smoothed trajectories, and used to indicate the progression of time.}

\item{traj.col.seg}{A vector of colors for segments along trajectories. If \code{NA} (default) then no segments along the trajectories appear in a color other than those specified by \code{"traj.col"}. This parameter applies to smoothed trajectories only.}

\item{traj.cex}{Used with \code{"traj.points"} for smoothed trajectories. Controls the size of symbol displayed.}

\item{traj.lab}{A vector of character labels that identify the trajectories. If unspecified, then products are identified by ascending natural numbers.}

\item{traj.lab.cex}{Text size of \code{traj.lab}.}

\item{arrow.loc}{Trajectory arrows locations for direction marker(s).}

\item{arrow.length}{Trajectory arrows length. See \code{length} parameter in \code{\link[graphics]{arrows}}.}

\item{arrow.col}{Trajectory arrows color. See \code{col} parameter in \code{\link[graphics]{arrows}}.}

\item{arrow.lwd}{Trajectory arrows line width. See \code{lwd} parameter in \code{\link[graphics]{arrows}}.}

\item{contrails}{list of data.frame objects with columns x, y, count, col; x and y are coordinates, count is the number of values at the coordinate, and col is the rbg colour.}

\item{main}{plot title; see \code{\link[graphics]{plot}}.}

\item{save.format}{If indicated, this will be the file type for the save image. Defaults to \code{"eps"} (eps format). Other possible values are \code{""} (not saved) or \code{"png"} (png format).}

\item{save.as}{The filename. Must be provided if the file will be saved.}
}
\description{
Plot trajectories following PCA on multiblock TCATA proportions, or same for Temporal Dominance of Sensations (TDS) proportions.
}
\examples{
# example using 'syrah' data set
syrah.pca <- prcomp(syrah[1:248, -c(1:4)], scale. = FALSE)
plot_pca.trajectories(syrah.pca, products.times = syrah[1:248, c(1, 4)],
                      attributes = colnames(syrah)[-c(1:4)], type = "raw")

# now with smoothing; may need to play with the span parameter to get appropriate smoothing
plot_pca.trajectories(syrah.pca, products.times = syrah[1:248, c(1, 4)],
                      attributes = colnames(syrah)[-c(1:4)], type = "smooth", span = 0.3)

# plots at each time point (trajectories join 2 points so start at timepoint 2, i.e., 11 s)
x <- 11:14 # for brevity show only the first 4 timeslices
# x <- 11:41 # uncomment this line to to run a longer demo
pca.list <- list()
for(i in seq_along(x)){
  pca.list[[x[i]-10]] <- syrah.pca
  pca.list[[x[i]-10]]$x <- pca.list[[x[i]-10]]$x[1:((x[i]-9)*6), ]
  plot_pca.trajectories(pca.list[[x[i]-10]], products.times = syrah[1:((x[i]-9)*6), c(1, 4)],
                        attributes = colnames(syrah)[-c(1:4)], type = "raw", inflate.factor = 1.5)
  Sys.sleep(3/4)
  # save plot if saving stills for a video; see Castura, Baker, & Ross (2016, Video 1)
}

}
\references{
Castura, J.C., Antúnez, L., Giménez, A., Ares, G. (2016). Temporal check-all-that-apply (TCATA): A novel temporal sensory method for characterizing products. \emph{Food Quality and Preference}, 47, 79-90. \url{http://dx.doi.org/10.1016/j.foodqual.2015.06.017}

Castura, J.C., Baker, A.K., & Ross, C.F. (2016). Using contrails and animated sequences to visualize uncertainty in dynamic sensory profiles obtained from temporal check-all-that-apply (TCATA) data. \emph{Food Quality and Preference}, 54, 90-100. \url{http://dx.doi.org/10.1016/j.foodqual.2016.06.011}
}
\seealso{
\code{\link[stats]{prcomp}}, \code{\link[graphics]{par}}
}
