% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tds.R
\encoding{UTF-8}
\name{get.significance.diff}
\alias{get.significance.diff}
\title{Get least significant differences for pairwise comparisons}
\usage{
get.significance.diff(x, y, alpha = 0.05)
}
\arguments{
\item{x}{matrix of dominance data (\code{0}/\code{1}) related to one entity}

\item{y}{matrix of dominance data (\code{0}/\code{1}) related to another entity}

\item{alpha}{significance for one-sided test (default \code{0.05})}
}
\value{
out least significant difference (at level \code{alpha}) for dominance differences in matrix
}
\description{
Get least significant differences for pairwise comparisons (see Pineau et al., 2009, Eq. 2).
}
\details{
Calculation of least significant differences for TDS difference curves based on Pineau et al. (2009, Eq. 2). The absolute value of the observed dominance rate for a give attribute*time must exceed the corresponding least significant difference calculated here to be considered significant.
}
\examples{
# toy data example
x <- data.frame(t10 = c(rep(NA, 15), rep(0, 50), rep(1, 20)),
                t15 = c(rep(NA,  4), rep(0, 61), rep(1, 20)),
                t20 = c(rep(0, 55), rep(1, 30)))
y <- data.frame(t10 = c(rep(NA, 15), rep(0, 50), rep(1, 20)),
                t15 = c(rep(NA,  0), rep(0, 21), rep(1, 64)),
                t20 = c( rep(0, 35), rep(1, 50)))
signif.xy <- get.significance.diff(x, y)
#compare with observed differences
diff.xy <- get.differences(x, y)
abs(diff.xy) > signif.xy

# real data example - differences between Bar 1 and Bar 2 on the attribute "Grain Flavour"
attributes <- unique(bars$attribute)
times <- get.times(colnames(bars)[-c(1:4)])
bar1 <- bars[bars$sample == 1 & bars$attribute == "Grain Flavour", -c(1:4)]
bar2 <- bars[bars$sample == 2 & bars$attribute == "Grain Flavour", -c(1:4)]
signif.1vs2 <- get.significance.diff(bar1, bar2)
# review observed difference in dominance rates vs. least significant differences
diff.1vs2 <- get.differences(bar1, bar2)
abs(diff.1vs2) > signif.1vs2
# differences between samples start at 1.1s and occur throughout the 45.0 evaluation period
}
\references{
Pineau, N., Schlich, P., Cordelle, S., Mathonnière, C., Issanchou, S., Imbert, A., Rogeaux, M., Etiévant, P., & Köster, E. (2009). Temporal dominance of sensations: Construction of the TDS curves and comparison with time–intensity.  \emph{Food Quality and Preference}, 20, 450–455. \url{http://dx.doi.org/10.1016/j.foodqual.2009.04.005}
}

