% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{convert.tcategory}
\alias{convert.tcategory}
\title{Convert Temporal Category data}
\usage{
convert.tcategory(X, in.scores, times, decimal.places = 2)
}
\arguments{
\item{X}{matrix with onset (start) times in first column and offset (stop) times in second column}

\item{in.scores}{vector of category values corresponding to rows of \code{X}}

\item{times}{time slices for output vector}

\item{decimal.places}{decimal places used in \code{times}; used for naming of the indices of \code{out.vec}}
}
\value{
out.vec indictor vector(\code{0}s and \code{1}s)
}
\description{
Converts Temporal Category data from a set of onset-offset times and ratings to an vector of ratings.
}
\examples{
X <- rbind(c(3.18, 6.83), c(8.46, 11.09), c(18.61, 21.80))
in.scores <- c(7, 6, 5)
times <- seq(0, 25, by = 0.01)
Xnew <- convert.tcategory(X, in.scores, times)
Xnew
}

