% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t2d.R
\name{write_t2d}
\alias{write_t2d}
\title{Write TELEMAC-2D files}
\usage{
write_t2d(x)
}
\arguments{
\item{x}{An object of class \code{t2d}.}
}
\value{
Returns input \code{x} invisibly.
}
\description{
Writes all input files of a TELEMAC-2D project setup.
}
\note{
This function is basically a wrapper around other \code{write_*} functions
of the telemac package.

The associated file of \code{x$res} will replace entry \code{RESULTS FILE}
in the steering parameters.

If \code{x$wdir} does not exist, it will be created.

If \code{x$wdir} is a relative path it will be considered relative to the current
working directory.

All \code{t2d_*} objects will be written to the associated filenames into directory
\code{wdir} (element of \code{x}). In case the associated
filenames contain a relative path the files will be written relative to \code{wdir}.

Existing files will be silently overwritten!

Parameters \code{BOUNDARY CONDITIONS FILE}, \code{GEOMETRY FILE}, \code{RESULTS FILE},
and \code{TITLE} will be adapted to the current setup.
}
