% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_shmax.R
\name{PoR_azi}
\alias{PoR_azi}
\alias{PoR_azimuth}
\alias{PoR_shmax}
\title{Azimuth Conversion from Geographical to PoR Coordinate Reference System}
\usage{
PoR_azimuth(x, PoR)

PoR_shmax(x, PoR, type = c("none", "in", "out", "right", "left"))
}
\arguments{
\item{x}{\code{sf} object or a \code{data.frame} containing the coordinates of the point(s)
(\code{lat}, \code{lon}). \code{x} must contain the direction of
\eqn{\sigma_{Hmax}}{SHmax} as column \code{azi} and its standard deviation
as \code{unc} (the latter is optional)}

\item{PoR}{\code{"data.frame"} or object of class \code{"euler.pole"}
containing the geographical coordinates of the Euler  pole}

\item{type}{Character. Type of plate boundary (optional). Can be
\code{"out"}, \code{"in"}, \code{"right"}, or
\code{"left"} for outward, inward, right-lateral, or left-lateral
moving plate boundaries, respectively. If \code{"none"} (the default), only
the PoR-equivalent azimuth is returned.}
}
\value{
\code{PoR_azimuth} returns numeric vector of the transformed azimuth in degrees.
\code{PoR_shmax} returns either a numeric vector of the azimuths in the
transformed coordinate system (in degrees), or a \code{"data.frame"} with
\describe{
\item{\code{azi.PoR}}{the transformed azimuths (in degrees),}
\item{\code{prd}}{the predicted azimuths (in degrees),}
\item{\code{dev}}{the deviation between the transformed and the predicted azimuth (in degrees),}
\item{\code{nchisq}}{the Norm \eqn{\chi^2}{chi-squared} test statistic, and}
\item{\code{cdist}}{the angular distance between the transformed and the predicted azimuth.}
}
}
\description{
Transforms azimuths and models the direction of maximum horizontal stress
\eqn{\sigma_{Hmax}}{SHmax} in the Euler pole (Pole of Rotation)
coordinate reference system. When type of plate boundary is given, it also
gives the deviation from the theoretically predicted azimuth of
\eqn{\sigma_{Hmax}}{SHmax}, the circular distance, and the normalized
\eqn{\chi^2}{chi-squared} statistics.
}
\details{
The azimuth of \eqn{\sigma_{Hmax}}{SHmax} in the pole of rotation
reference system is
approximate 0 (or 180), 45, 90, 135 degrees if the stress is sourced by an
outward, sinistral, inward, or dextral moving plate boundary, respectively.
directions of \eqn{\sigma_{Hmax}}{SHmax} with respect to the four
plate boundary types.
}
\examples{
data("nuvel1")
# North America relative to Pacific plate:
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")

data("san_andreas")
res <- PoR_shmax(san_andreas, PoR, type = "right")
head(res)
}
\references{
Stephan, T., Enkelmann, E., and Kroner, U. "Analyzing the
horizontal orientation of the crustal stress adjacent to plate boundaries".
\emph{Sci Rep} 13. 15590 (2023). \doi{10.1038/s41598-023-42433-2}.
}
\seealso{
\code{\link[=model_shmax]{model_shmax()}} to compute the theoretical direction of
\eqn{\sigma_{Hmax}}{SHmax} in the geographical reference system.
\code{\link[=deviation_shmax]{deviation_shmax()}} to compute the deviation of the modeled direction
from the observed direction of \eqn{\sigma_{Hmax}}{SHmax}.
\code{\link[=norm_chisq]{norm_chisq()}} to calculate the normalized \eqn{\chi^2}{chi-squared}
statistics. \code{\link[=circular_distance]{circular_distance()}} to calculate the angular distance.
}
