% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{confidence}
\alias{confidence}
\alias{confidence_angle}
\alias{confidence_interval}
\title{Confidence Interval around the Mean Direction of Circular Data}
\usage{
confidence_angle(x, conf.level = 0.95, w = NULL, axial = TRUE, na.rm = TRUE)

confidence_interval(x, conf.level = 0.95, w = NULL, axial = TRUE, na.rm = TRUE)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{conf.level}{Level of confidence: \eqn{(1 - \alpha \%)/100}.
(\code{0.95} by default).}

\item{w}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\value{
Angle in degrees
}
\description{
Probabilistic limit on the location of the true or population mean direction,
assuming that the estimation errors are normally distributed.
}
\details{
The confidence angle gives the interval, i.e. plus and minus the confidence angle,
around the mean direction of a particular sample, that contains the true
mean direction under a given level of confidence.
}
\examples{
# Example data from Davis (1986), pp. 316
finland_stria <- c(
  23, 27, 53, 58, 64, 83, 85, 88, 93, 99, 100, 105, 113,
  113, 114, 117, 121, 123, 125, 126, 126, 126, 127, 127, 128, 128, 129, 132,
  132, 132, 134, 135, 137, 144, 145, 145, 146, 153, 155, 155, 155, 157, 163,
  165, 171, 172, 179, 181, 186, 190, 212
)
confidence_angle(finland_stria, axial = FALSE)
confidence_interval(finland_stria, axial = FALSE)

data(san_andreas)
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
confidence_angle(sa.por$azi.PoR, w = 1 / san_andreas$unc)
confidence_interval(sa.por$azi.PoR, w = 1 / san_andreas$unc)
}
\references{
\itemize{
\item Davis (1986) Statistics and data analysis in geology. 2nd ed., John Wiley
& Sons.
\item Jammalamadaka, S. Rao and Sengupta, A. (2001). Topics in Circular
Statistics, Sections 3.3.3 and 3.4.1, World Scientific Press, Singapore.
}
}
\seealso{
\code{\link[=mean_resultant_length]{mean_resultant_length()}}, \code{\link[=circular_sd_error]{circular_sd_error()}}
}
