% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_teal.R
\name{module_teal}
\alias{module_teal}
\alias{ui_teal}
\alias{srv_teal}
\title{\code{teal} main app module}
\usage{
ui_teal(
  id,
  splash_ui = tags$h2("Starting the Teal App"),
  title = build_app_title(),
  header = tags$p(),
  footer = tags$p()
)

srv_teal(id, modules, teal_data_rv, filter = teal_slices())
}
\arguments{
\item{id}{(\code{character(1)})
module id}

\item{splash_ui}{(\code{shiny.tag}) UI to display initially,
can be a splash screen or a \code{shiny} module UI. For the latter, see
\code{\link[=init]{init()}} about how to call the corresponding server function.}

\item{title}{(\code{shiny.tag} or \code{character(1)})
The browser window title. Defaults to a title "teal app" with the icon of NEST.
Can be created using the \code{build_app_title()} or
by passing a valid \code{shiny.tag} which is a head tag with title and link tag.}

\item{header}{(\code{shiny.tag} or \code{character(1)})
The header of the app.}

\item{footer}{(\code{shiny.tag} or \code{character(1)})
The footer of the app.}

\item{modules}{(\code{teal_modules}) object containing the output modules which
will be displayed in the \code{teal} application. See \code{\link[=modules]{modules()}} and \code{\link[=module]{module()}} for
more details.}

\item{teal_data_rv}{(\code{reactive})
returns the \code{teal_data}, only evaluated once, \code{NULL} value is ignored}

\item{filter}{(\code{teal_slices})
Specifies the initial filter using \code{\link[=teal_slices]{teal_slices()}}.}
}
\value{
Returns a \code{reactive} expression which returns the currently active module.
}
\description{
This is the main \code{teal} app that puts everything together.
}
\details{
It displays the splash UI which is used to fetch the data, possibly
prompting for a password input to fetch the data. Once the data is ready,
the splash screen is replaced by the actual \code{teal} UI that is tabsetted and
has a filter panel with \code{datanames} that are relevant for the current tab.
Nested tabs are possible, but we limit it to two nesting levels for reasons
of clarity of the UI.

The splash screen functionality can also be used
for non-delayed data which takes time to load into memory, avoiding
\code{shiny} session timeouts.

Server evaluates the \code{teal_data_rv} (delayed data mechanism) and creates the
\code{datasets} object that is shared across modules.
Once it is ready and non-\code{NULL}, the splash screen is replaced by the
main \code{teal} UI that depends on the data.
The currently active tab is tracked and the right filter panel
updates the displayed datasets to filter for according to the active \code{datanames}
of the tab.

It is written as a \code{shiny} module so it can be added into other apps as well.
}
\keyword{internal}
