% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_file_viewer.R
\name{tm_file_viewer}
\alias{tm_file_viewer}
\title{\code{teal} module: File viewer}
\usage{
tm_file_viewer(
  label = "File Viewer Module",
  input_path = list(`Current Working Directory` = ".")
)
}
\arguments{
\item{label}{(\code{character(1)}) Label shown in the navigation item for the module or module group.
For \code{modules()} defaults to \code{"root"}. See \code{Details}.}

\item{input_path}{(\code{list}) of the input paths, optional. Each element can be:

Paths can be specified as absolute paths or relative to the running directory of the application.
Default to the current working directory if not supplied.}
}
\value{
Object of class \code{teal_module} to be used in \code{teal} applications.
}
\description{
The file viewer module provides a tool to view static files.
Supported formats include text formats, \code{PDF}, \code{PNG} \code{APNG},
\code{JPEG} \code{SVG}, \code{WEBP}, \code{GIF} and \code{BMP}.
}
\examples{
data <- teal_data()
data <- within(data, {
  data <- data.frame(1)
})
datanames(data) <- c("data")

app <- init(
  data = data,
  modules = modules(
    tm_file_viewer(
      input_path = list(
        folder = system.file("sample_files", package = "teal.modules.general"),
        png = system.file("sample_files/sample_file.png", package = "teal.modules.general"),
        txt = system.file("sample_files/sample_file.txt", package = "teal.modules.general"),
        url = "https://fda.gov/files/drugs/published/Portable-Document-Format-Specifications.pdf"
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
