% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substitute_names.R
\name{substitute_names}
\alias{substitute_names}
\alias{h_subst_lhs_names}
\alias{substitute_lhs_names}
\alias{substitute_rhs}
\title{Substitute Names in a Quoted Expression}
\usage{
substitute_names(expr, names, others = list())

h_subst_lhs_names(qexpr, names)

substitute_lhs_names(qexpr, names)

substitute_rhs(qexpr, env)
}
\arguments{
\item{expr}{(\code{language})\cr an expression.}

\item{names}{(named \code{list} of \code{name})\cr requested name substitutions.}

\item{others}{(named \code{list})\cr requested other substitutions which will only happen on the
right-hand side.}

\item{qexpr}{(\code{language})\cr a quoted expression.}

\item{env}{(\code{environment} or \code{list})\cr requested variable substitutions.}
}
\value{
The modified expression.
}
\description{
This function substitutes the names on both left- and right-hand sides in a quoted expression.
In addition it can also do other standard substitutions on the right-hand side.
}
\section{Functions}{
\itemize{
\item \code{h_subst_lhs_names()}: Helper function to just substitute the top-level names on the left-hand side in a
quoted expression.

\item \code{substitute_lhs_names()}: recursively substitutes all names on the left-hand sides in a quoted expression.

\item \code{substitute_rhs()}: substitutes on the right-hand side in a quoted expression.
Note that this is just a synonym for \code{\link[=substitute_q]{substitute_q()}}.

}}
\seealso{
\code{\link[=substitute_q]{substitute_q()}}
}
\keyword{internal}
