ui = fluidPage(theme = add_theme(getShinyOption('theme')), 
               add_css(),
               
sidebarLayout(
   sidebarPanel(width = 3,
      sliderInput(inputId = "sample",
                  label = "Sample size",
                  value = 50, 
                  min = 10, 
                  max = 100),
      hr(),
      sliderInput(inputId = "slope",
                  label = "Regression slope",
                  value = .25, 
                  min = -2, 
                  max = 2,
                  step = .25),
      hr(),
      sliderInput(inputId = "SD",
                  label = "Standard deviation",
                  value = 3, 
                  min = 0, 
                  max = 50),
      hr(),
      actionButton(width = '100%',
                   inputId = "refresh", 
                   label = "Simulate New Data")),
      
   mainPanel(width = 9,
      tabsetPanel(type = "pills",
                  tabPanel("Total",
                           plotOutput("total",  height = '550px')),
                  tabPanel("Regression",
                           plotOutput("regress",height = '550px')),
                  tabPanel("Error",
                           plotOutput("error",  height = '550px'))))))
