% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{remove.na.strategies}
\alias{remove.na.strategies}
\title{Scenarios for Removing \code{NA}s}
\usage{
remove.na.strategies(
  data,
  countFun = function(nRows, nCols) nRows * nCols,
  rowIndices = NULL,
  colIndices = NULL,
  printMsg = FALSE
)
}
\arguments{
\item{data}{A matrix that contains \code{NA} values.}

\item{countFun}{A function to determine how strategies are sorted. The default function counts the number of observations.
You might want to give columns a higher level of importance, for example, by using \code{nRows*nCols^1.5}.}

\item{rowIndices}{The indices of the sorted rows to search.
Use this to create jumps for a large number of rows (e.g., if the first sorted strategies suggest a small number of columns and you are looking for other strategies).
Use \code{NULL} to disable it.}

\item{colIndices}{Similar to \code{rowIndices}, but for columns.}

\item{printMsg}{If \code{TRUE}, it prints the progress.}
}
\value{
A list of lists, each with the following elements:
\item{nRows}{The number of rows in the matrix.}
\item{nCols}{The number of columns in the matrix.}
\item{colRemove}{The indices of the columns to be removed.}
\item{rowRemove}{The indices of the rows to be removed.}
}
\description{
Use this function to remove \code{NA} values from a matrix. This helps you to optimize the size of the information.
}
\details{
When a matrix has \code{NA} values, one can omit columns with \code{NA}, rows with \code{NA}, or a combination of these two. The total number of observations is a function of the order. This function tries all combinations and returns the results.
}
\examples{
data <- matrix(c(NA, 2, 3, 4, NA, 5, NA, 6, 7, NA, 9, 10, 11, 12, 13, 14, 15, NA, 16, 17), 4, 5)
res <- remove.na.strategies(data)
}
