% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplPlot.R
\name{tcplPlot}
\alias{tcplPlot}
\title{#-------------------------------------------------------------------------------
 Generic Plotting Function for tcpl}
\usage{
tcplPlot(
  lvl = 5,
  fld = "m4id",
  val = NULL,
  type = "mc",
  by = NULL,
  output = c("console", "pdf"),
  fileprefix = paste0("tcplPlot_", Sys.Date()),
  multi = FALSE,
  verbose = FALSE,
  nrow = NULL,
  ncol = NULL
)
}
\arguments{
\item{lvl}{Integer of length 1, the level of data to load}

\item{fld}{Character, the field(s) to query on}

\item{val}{List, vectors of values for each field to query on. Must be in
the same order as 'fld'.}

\item{type}{Character of length 1, the data type, "sc" or "mc"}

\item{by}{Paramater to divide files into e.g. aeid}

\item{output}{how should the output be presented}

\item{fileprefix}{prefix of filename}

\item{multi}{Boolean, if multi is TRUE output 6 plots per page}

\item{verbose}{By default FALSE, should a table with fitting parameters be included in the plot}

\item{nrow}{Integer, number of rows in multiplot default of 2}

\item{ncol}{Integer, number of columns in multiplot default of 3, 2 if verbose}
}
\description{
\code{tcplLoadData} queries the tcpl databases and returns a plot
for the given level and data type.
}
\details{
The data type can be either 'mc' for mutliple concentration data, or 'sc'
for single concentration data. Multiple concentration data will be loaded
into the 'mc' tables, whereas the single concentration will be loaded into
the 'sc' tables.

Setting 'lvl' to "agg" will return an aggregate table containing the m4id
with the concentration-response data and m3id to map back to well-level
information.

Leaving \code{fld} NULL will return all data.
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- tcplConfList()
tcplConfExample()

tcplPlot(lvl = 4, fld = "m4id", val = c(18609966)) ## Create a level 4 plot

## Reset configuration
options(conf_store)
}
