% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplPlotFits.R
\name{tcplPlotFits}
\alias{tcplPlotFits}
\title{Plot summary fits based on fit and dose-response data}
\usage{
tcplPlotFits(dat, agg, flg = NULL, boot = NULL, ordr.fitc = FALSE,
  browse = FALSE)
}
\arguments{
\item{dat}{data.table, level 4 or level 5 data, see details.}

\item{agg}{data.table, concentration-response aggregate data, see details.}

\item{flg}{data.table, level 6 data, see details.}

\item{boot}{data.table, level 7 data, see details.}

\item{ordr.fitc}{Logical, should the fits be ordered by fit category?}

\item{browse}{Logical, should \code{browser()} be called after every plot?}
}
\description{
\code{tcplPlotFits} takes the dose-response and fit data and produces
summary plot figures.
}
\details{
The data for 'dat', 'agg', and 'flg' should be loaded using the 
\code{\link{tcplLoadData}} function with the appropriate 'lvl' parameter.
See help page for \code{tcplLoadData} for more information.

Supplying level 4 data for the 'dat' parameter will result in level 4 plots. 
Similarly, supp

If fits are not ordered by fit category, they will be ordered by chemical 
ID. Inputs with multiple assay endpoints will first be ordered by assay 
endpoint ID.
}
\examples{

## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- tcplConfList()
tcplConfDefault()

## tcplPlotFits needs data.tables supplying the concentration/response
## data stored in mc4_agg, as well as the fit information from mc4 or mc5.
## Additionally, tcplPlotFits can take level 6 data from mc6 and add the
## flag information to the plots. The following shows how to make level 5
## plots. Adding the 'flg' parameter would result in level 6 plots, and 
## loading level 4, rather than level 5 data, would result in level 4 plots.
 
l5 <- tcplLoadData(lvl = 5, fld = "m4id", val = 18609966)
l4_agg <- tcplLoadData(lvl = "agg", fld = "m4id", val = 18609966)

\dontrun{
pdf(file = "tcplPlotFits.pdf", height = 6, width = 10, pointsize = 10)
tcplPlotFits(dat = l5, agg = l4_agg)
graphics.off()
}

## While it is most likely the user will want to just save all of the plots 
## to view in a PDF, the 'browse' parameter can be used to quickly view 
## some plots. 

## Start by identifying some sample IDs to plot, then call tcplPlotFits with
## a subset of the data. This browse function is admittedly clunky. 
bpa <- tcplLoadChem(field = "chnm", val = "Bisphenol A")[ , spid]
l5_sub <- l5[spid \%in\% bpa] 
\dontrun{
tcplPlotFits(dat = l5_sub, 
             agg = l4_agg[m4id \%in\% l5_sub$m4id], 
             browse = TRUE)
}

## Reset configuration
options(conf_store)
 
}
