% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscrFact.R
\name{DiscrFact}
\alias{DiscrFact}
\alias{print.DiscrFact}
\title{Discriminant Factor analysis for \code{tclust} objects}
\usage{
DiscrFact(x, threshold = 1/10)
}
\arguments{
\item{x}{A \code{tclust} object.}

\item{threshold}{A cluster assignment or a trimming decision for an observation with a 
discriminant factor larger than \code{log(threshold)} is considered a "doubtful" decision.}
}
\value{
The function returns an S3 object of type \code{DiscrFact} containing the following components:
\itemize{
     \item \code{x} A \code{tclust} object. 
     \item \code{ylimmin} A minimum y-limit calculated for plotting purposes. 
    \item \code{ind} The actual cluster assignment. 
    \item \code{ind2} The second most likely cluster assignment for each observation. 
    \item \code{lik} The (weighted) likelihood of the actual cluster assignment of each observation. 
    \item \code{lik2} The (weighted) likelihood of the second best cluster assignment of each observation. 
    \item \code{assignfact} The factor \code{log(disc/disc2)}. 
    \item \code{threshold} The threshold used for deciding whether \code{assignfact} indicates a "doubtful" assignment. 
    \item \code{mean.DiscrFact} A vector of length \code{k + 1} containing the mean discriminant 
     factors for each cluster (including the outliers). 
 }
}
\description{
Analyzes a \code{tclust}-object by calculating discriminant factors 
 and comparing the quality of the actual cluster assignments to that of the second best 
 possible assignment for each observation. Cluster assignments of observations 
 with large discriminant factors are considered "doubtful" decisions. Silhouette 
 plots give a graphical overview of the discriminant factors distribution 
 (see \code{\link{plot.DiscrFact}}). More details can be found in García-Escudero et al. (2011).
}
\references{
\enc{García}{Garcia}-Escudero, L.A.; Gordaliza, A.; \enc{Matrán}{Matran}, C. and Mayo-Iscar, A. (2011), 
   "Exploring the number of groups in robust model-based clustering." \emph{Statistics and Computing}, \bold{21} 
   pp. 585-599, <doi:10.1007/s11222-010-9194-z>
}
