% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{log_likelihood}
\alias{log_likelihood}
\title{Evaluate log-likelihood}
\usage{
log_likelihood(lpr, dat, pk_ix, pd_ix, fixed_ix = NULL, fixed_lpr = NULL)
}
\arguments{
\item{lpr}{Set of logged PK-PD-error parameter values to be updated. The final value of lpr is
assumed to be the residual error term.}

\item{dat}{data frame with columns c("time","bis") corresponding to observed time and bis values}

\item{pk_ix}{indices of (pars_pk,pars_pd) corresponding to PK function values}

\item{pd_ix}{indices of (pars_pk,pars_pd) corresponding to PD function values}

\item{fixed_ix}{indices of (pars_pk,pars_pd) corresponding to PD function values}

\item{fixed_lpr}{values used by PD function that are not updated.}
}
\value{
Returns a numeric value representing the logged likelihood value associated with parameter values 'lpr'
and observed data in matrix 'dat'. Observations are assumed to follow a truncated normal distribution with
lower bound 0 if only a PK model is specified and bounded by 0 and 100 if a PD model is also provided.
}
\description{
Function to evaluate the log likelihood given a set of logged parameter values and a set of observed BIS values.
It is assumed that the full set of parameters are given by indices (pk_ix, pd_ix), of which a subset may be
fixed (i.e. not updated, but still used to evaluate PK-PD functions).
}
