% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{apply_targetfn}
\alias{apply_targetfn}
\title{#' Sigmoid target function
#'
#' @param lpars Logged parameter values
#' @param tms Times to evaluate sigmoid function
#' @param bis0 BIS value with no drug administered
#' @param ... Arguments passed on to 'restrict_sigmoid' function
#' @return Returns numeric vector of BIS values corresponding to an Emax sigmoidal
#' target function with parameter bis0.
#' @export
sigmoid_targetfn <- function(lpars, tms, bis0 = 93, ...)
  emax(tms, restrict_sigmoid(t50 = exp(lpars), BIS0 = bis0, ...))
Apply target function to a PK-PD model}
\usage{
apply_targetfn(
  lp,
  tm,
  targetfn,
  prior_pk,
  prior_pd,
  pkmod = pkmod3cptm,
  pdmod = emax_eleveld,
  pdinv = inv_emax_eleveld,
  ...
)
}
\arguments{
\item{lp}{Logged parameter values}

\item{tm}{Time values to evaluate}

\item{targetfn}{Target function}

\item{prior_pk}{Prior PK point estimates}

\item{prior_pd}{Prior PD point estimates}

\item{pkmod}{PK model to evaluate}

\item{pdmod}{PD model to evaluate}

\item{pdinv}{Inverse PD model}

\item{...}{Additional arguments passed on to tci_pd}
}
\value{
Return a set of infusions designed to reach a target function
specified in argument 'targetfn'.
}
\description{
Function to apply any specified target function to a PK-PD model
and TCI algorithm. 'targetfn' should be a function with parameters
'lp' as the first argument and times 'tm' as the second.
}
