% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{taylor_all_songs}
\alias{taylor_all_songs}
\alias{taylor_album_songs}
\title{Data for Taylor Swift songs}
\format{
\code{taylor_all_songs} is a \link[tibble:tibble-package]{tibble} with
364 rows and 29 variables.
Each row is one song.
\itemize{
\item \code{album_name}: The name of the album. \code{NA} if the song was released
separately from one of Taylor's studio albums or EPs.
\item \code{ep}: Logical. Is the album a full studio album (\code{FALSE}) or an extended
play (\code{TRUE}).
\item \code{album_release}: The date the album was released, in the ISO-8601 format
(YYYY-MM-DD).
\item \code{track_number}: The order of the song on the album or EP.
\item \code{track_name}: The name of the song.
\item \code{artist}: The name of the song artist. Usually Taylor Swift, but will show
other artists for songs that Taylor is only featured on.
\item \code{featuring}: Any artists that are featured on the track.
\item \code{bonus_track}: Logical. Is the track only present on a deluxe edition of
the album (\code{TRUE}) or is does it also appear on the standard version
(\code{FALSE}).
\item \code{promotional_release}: The date the song was released as a promotional
single, in the ISO-8601 format (YYYY-MM-DD).. \code{NA} if the song was never
released as a promotional single.
\item \code{single_release}: The date the song was released as an official single, in
the ISO-8601 format (YYYY-MM-DD). \code{NA} if the song was never released as an
official single.
\item \code{track_release}: The date the song was first publicly released. This is the
earliest of \code{album_release}, \code{promotional_release}, and \code{single_release}.
}

The next set of variables come from the Spotify API. See the documentation at
\url{https://developer.spotify.com/documentation/web-api/reference/} for complete
details.
\itemize{
\item \code{danceability}: How suitable a track is for dancing. \code{0.0} = least
danceable, \code{1.0} = most danceable.
\item \code{energy}: Perceptual measure of intensity and activity. \code{0.0} = least
energy, \code{1.0} = most energy.
\item \code{key}: The key the track is in. Integer maps to standard Pitch Class
notation.
\item \code{loudness}: Loudness of track in decibels (dB), averaged across the track.
\item \code{mode}: Modality of a track (major/minor). \code{0} = minor, \code{1} = major.
\item \code{speechiness}: The presence of spoken words in a track. Values above \code{0.66}
indicate that the track is probably made entirely of spoken words. Values
between \code{0.33} and \code{0.66} indicate both music and speech. Values less than
\code{0.33} indicate the track is probably music or other non-speech tracks.
\item \code{acousticness}: Confidence that the track is acoustic. \code{0.0} = low
confidence, \code{1.0} = high confidence.
\item \code{instrumentalness}: Confidence that the track is an instrumental track
(i.e., no vocals). \code{0.0} = low confidence, \code{1.0} = high confidence.
\item \code{liveness}: Confidence that the track is a live recording (i.e., an
audience is present). \code{0.0} = low confidence, \code{1.0} = high confidence.
\item \code{valence}: Musical positiveness conveyed by the track. \code{0.0} = low valence
(e.g., sad, depressed, angry), \code{1.0} = high valence (e.g., happy, cheerful,
euphoric).
\item \code{tempo}: Estimated tempo of the track in beats per minute (BPM).
\item \code{time_signature}: Estimated overall time signature.
\item \code{duration_ms}: Duration of the track in milliseconds.
\item \code{explicit}: Logical. Does the track contain explicit lyrics (\code{TRUE}) or not
(\code{FALSE}).
}

Finally, the last set of variables includes those calculated from the Spotify
API data, and a list-column containing song lyrics.
\itemize{
\item \code{key_name}: Corresponds directly to the \code{key}, but the integer is converted
to the key name using Pitch Class notation (e.g., \code{0} becomes \code{C}).
\item \code{mode_name}: Corresponds directly to the \code{mode}, but the integer is
converted to the mode name (e.g., \code{0} becomes \code{minor}).
\item \code{key_mode}: A combination of the \code{key_name} and \code{mode_name} variables
(e.g., \verb{C minor}).
\item \code{lyrics}: A list-column containing the lyrics to each song. The lyrics can
be unnested with \code{\link[tidyr:unnest]{tidyr::unnest()}} (i.e.,
\code{tidyr::unnest(taylor_all_songs, lyrics)}). Each element is a data frame
with 4 variables. :
\itemize{
\item \code{line}: The line number of the song.
\item \code{lyric}: The lyric for the given line.
\item \code{element}: The element of the song the line and lyric belong to, as
defined by \url{https://genius.com/} (e.g., \verb{Verse 1}, \code{Chorus}, etc.).
\item \code{element_artist}: The artist performing the element. Usually
\verb{Taylor Swift}, but other artists appear if they are featured on the
track (e.g., \code{HAIM} is featured on \emph{no body, no crime}).
}
}

\code{taylor_album_songs} is a \link[tibble:tibble-package]{tibble} containing
the same 29 variables, but only with
240 rows, one for each song from an official studio
album (see Details).
}
\source{
\url{https://genius.com/artists/Taylor-swift}

\url{https://open.spotify.com/artist/06HL4z0CvFAxyc27GXpf02}
}
\usage{
taylor_all_songs

taylor_album_songs
}
\description{
A data set containing lyrics to, and characteristics of, all officially
released Taylor Swift songs. This includes albums, EPs, and individually
released singles.
}
\details{
\code{taylor_all_songs} contains all songs in Taylor's discography.
Lyrics come from Genius, and songs characteristics come from the Spotify API.
Some data is known to be missing. The Beautiful Eyes EP is not available on
any streaming service, and therefore has no data from the Spotify API.
Similarly, the song \emph{American Girl}, a cover of the Tom Petty original, was
released exclusively on Rhapsody (now Napster), and therefore also does not
have data from the Spotify API.

For songs released separately from Taylor's official albums or EPs, album
information is not included. For example, \emph{I Don't Wanna Live Forever} was
released as part of the \emph{Fifty Shades Darker} movie soundtrack. However, the
\code{album_name} column for this song is \code{NA}, indicating that it does not appear
on one of Taylor's albums.

Songs are only included one time. For example, if a song appears on both the
standard and deluxe version of an album, there is only one record of the
song in the data set. Similarly, compilations are not included. For example,
following the release of \emph{folklore}, Taylor released several EPs that were
subsets of the original \emph{folklore} album (e.g., \emph{folklore: the escapism
chapter}, \emph{folklore: the sleepless nights chapter}, etc.). These are not
included. Finally, all bonus tracks (with the exception of voice
memos or similar) are included; however, for consistency, the album name is
always the shortened, common name. For example, \emph{the lakes} is a bonus track
from \emph{folklore (deluxe edition)}, but the \code{album_name} is listed only as
\emph{folklore}. The \code{bonus_track} variable can be used to determine which songs
appeared on the standard version of an album vs. a deluxe or platinum
edition.

\code{taylor_album_songs} contains the same information as \code{taylor_all_songs}, but
only for Taylor's official studio albums. Thus, \code{taylor_album_songs} is a
subset of \code{\link{taylor_all_songs}}, with EPs and individual singles excluded.
Critically, this subset also only includes versions owned by Taylor when
possible, because we stan artists owning their own work. This means that
although both \emph{Fearless} and \emph{Fearless (Taylor's Version)} appear in the full
\code{\link{taylor_all_songs}} data, only \emph{Fearless (Taylor's Version)} appears in this
subset. This also means that this data set will change as additional
re-releases are made available (i.e., \emph{Red} was replaced with
\emph{Red (Taylor's Version)} in \href{https://wjakethompson.com/blog/taylor/2021-12-17-taylor-1.0.0/}{version 1.0.0}).
}
\keyword{datasets}
